/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.ability;

import java.util.List;
import java.util.Optional;
import mods.flammpfeil.slashblade.ability.StunManager;
import mods.flammpfeil.slashblade.capability.mobeffect.CapabilityMobEffect;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class Untouchable {
    static final int JUMP_TICKS = 10;

    public static Untouchable getInstance() {
        return SingletonHolder.instance;
    }

    private Untouchable() {
    }

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void setUntouchable(LivingEntity entity, int ticks) {
        entity.getCapability(CapabilityMobEffect.MOB_EFFECT).ifPresent(ef -> {
            ef.setManagedUntouchable(entity.m_9236_().m_46467_(), ticks);
            ef.storeEffects(entity.m_21221_().keySet());
            ef.storeHealth(entity.m_21223_());
        });
    }

    private boolean checkUntouchable(LivingEntity entity) {
        Optional isUntouchable = entity.getCapability(CapabilityMobEffect.MOB_EFFECT).map(ef -> ef.isUntouchable(entity.m_20193_().m_46467_()));
        return isUntouchable.orElseGet(() -> false);
    }

    private void doWitchTime(Entity entity) {
        if (entity == null) {
            return;
        }
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        StunManager.setStun((LivingEntity)entity);
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        if (this.checkUntouchable(event.getEntity())) {
            event.setCanceled(true);
            this.doWitchTime(event.getSource().m_7639_());
        }
    }

    @SubscribeEvent
    public void onLivingDamage(LivingDamageEvent event) {
        if (this.checkUntouchable(event.getEntity())) {
            event.setCanceled(true);
            this.doWitchTime(event.getSource().m_7639_());
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        if (this.checkUntouchable(event.getEntity())) {
            event.setCanceled(true);
            this.doWitchTime(event.getSource().m_7639_());
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (this.checkUntouchable(event.getEntity())) {
            event.setCanceled(true);
            this.doWitchTime(event.getSource().m_7639_());
            LivingEntity entity = event.getEntity();
            entity.getCapability(CapabilityMobEffect.MOB_EFFECT).ifPresent(ef -> {
                if (ef.hasUntouchableWorked()) {
                    List<MobEffect> filterd = entity.m_21221_().keySet().stream().filter(p -> !ef.getEffectSet().contains(p) && !p.m_19486_()).toList();
                    filterd.forEach(p -> entity.m_21195_(p));
                    float storedHealth = ef.getStoredHealth();
                    if (ef.getStoredHealth() < storedHealth) {
                        entity.m_21153_(ef.getStoredHealth());
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public void onLivingTicks(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_9236_().f_46443_) {
            return;
        }
        entity.getCapability(CapabilityMobEffect.MOB_EFFECT).ifPresent(ef -> {
            if (ef.hasUntouchableWorked()) {
                ef.setUntouchableWorked(false);
                List<MobEffect> filterd = entity.m_21221_().keySet().stream().filter(p -> !ef.getEffectSet().contains(p) && !p.m_19486_()).toList();
                filterd.forEach(p -> entity.m_21195_(p));
                float storedHealth = ef.getStoredHealth();
                if (ef.getStoredHealth() < storedHealth) {
                    entity.m_21153_(ef.getStoredHealth());
                }
            }
        });
    }

    @SubscribeEvent
    public void onPlayerJump(LivingEvent.LivingJumpEvent event) {
        if (!event.getEntity().m_21205_().getCapability(ItemSlashBlade.BLADESTATE).isPresent()) {
            return;
        }
        Untouchable.setUntouchable(event.getEntity(), 10);
    }

    private static final class SingletonHolder {
        private static final Untouchable instance = new Untouchable();

        private SingletonHolder() {
        }
    }
}

