/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.capability.slashblade;

import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mods.flammpfeil.slashblade.ability.ArrowReflector;
import mods.flammpfeil.slashblade.ability.StunManager;
import mods.flammpfeil.slashblade.capability.inputstate.IInputState;
import mods.flammpfeil.slashblade.capability.slashblade.combo.Extra;
import mods.flammpfeil.slashblade.event.FallHandler;
import mods.flammpfeil.slashblade.event.KnockBackHandler;
import mods.flammpfeil.slashblade.event.client.UserPoseOverrider;
import mods.flammpfeil.slashblade.init.DefaultResources;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.specialattack.JudgementCut;
import mods.flammpfeil.slashblade.specialattack.SlashArts;
import mods.flammpfeil.slashblade.util.AdvancementHelper;
import mods.flammpfeil.slashblade.util.AttackManager;
import mods.flammpfeil.slashblade.util.InputCommand;
import mods.flammpfeil.slashblade.util.KnockBacks;
import mods.flammpfeil.slashblade.util.RegistryBase;
import mods.flammpfeil.slashblade.util.TimeValueHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;

public class ComboState
extends RegistryBase<ComboState> {
    static Map<ResourceLocation, ComboState> registry = Maps.newHashMap();
    public static final Capability<IInputState> INPUT_STATE = CapabilityManager.get((CapabilityToken)new CapabilityToken<IInputState>(){});
    public static final ComboState NONE = new ComboState(BaseInstanceName, 1000, () -> 0, () -> 1, () -> Float.valueOf(1.0f), () -> true, () -> 0, DefaultResources.ExMotionLocation, a -> NONE, () -> NONE).addTickAction(e -> UserPoseOverrider.resetRot((Entity)e));
    static List<Map.Entry<EnumSet<InputCommand>, Supplier<ComboState>>> standbyMap = new HashMap<EnumSet<InputCommand>, Supplier<ComboState>>(){
        {
            this.put(EnumSet.of(InputCommand.ON_GROUND, InputCommand.SNEAK, InputCommand.FORWARD, InputCommand.R_CLICK), () -> ARTS_RAPID_SLASH);
            this.put(EnumSet.of(InputCommand.ON_GROUND, InputCommand.L_CLICK), () -> COMBO_B1);
            this.put(EnumSet.of(InputCommand.ON_GROUND, InputCommand.BACK, InputCommand.SNEAK, InputCommand.R_CLICK), () -> COMBO_B1);
            this.put(EnumSet.of(InputCommand.ON_GROUND, InputCommand.R_CLICK), () -> COMBO_A1);
            this.put(EnumSet.of(InputCommand.ON_AIR, InputCommand.SNEAK, InputCommand.FORWARD, InputCommand.R_CLICK), () -> ARTS_HELM_BREAKER);
            this.put(EnumSet.of(InputCommand.ON_AIR), () -> COMBO_AA1);
        }
    }.entrySet().stream().collect(Collectors.toList());
    public static final ComboState STANDBY = new ComboState("standby_old", 10, () -> 30, () -> 31, () -> Float.valueOf(1.0f), () -> true, () -> 1000, DefaultResources.BaseMotionLocation, a -> {
        EnumSet commands = a.getCapability(INPUT_STATE).map(state -> state.getCommands((LivingEntity)a)).orElseGet(() -> EnumSet.noneOf(InputCommand.class));
        return standbyMap.stream().filter(entry -> commands.containsAll((Collection)entry.getKey())).min(Comparator.comparingInt(entry -> ((ComboState)((Supplier)entry.getValue()).get()).getPriority())).map(entry -> (ComboState)((Supplier)entry.getValue()).get()).orElseGet(() -> NONE);
    }, () -> NONE);
    public static final ComboState COMBO_A1 = new ComboState("combo_a1", 100, () -> 60, () -> 70, () -> Float.valueOf(1.5f), () -> false, () -> 1000, DefaultResources.BaseMotionLocation, a -> COMBO_A2, () -> NONE).setClickAction(e -> AttackManager.areaAttack(e, KnockBackHandler::setCancel)).addHitEffect(StunManager::setStun);
    public static final ComboState COMBO_A2 = new ComboState("combo_a2", 100, () -> 70, () -> 80, () -> Float.valueOf(1.5f), () -> false, () -> 1000, DefaultResources.BaseMotionLocation, a -> COMBO_A3, () -> NONE).setClickAction(e -> AttackManager.areaAttack(e, KnockBackHandler::setCancel)).addHitEffect(StunManager::setStun);
    public static final ComboState COMBO_A3 = new ComboState("combo_a3", 100, () -> 80, () -> 90, () -> Float.valueOf(1.75f), () -> false, () -> 600, DefaultResources.BaseMotionLocation, a -> NONE, () -> COMBO_A3_F).setClickAction(e -> AttackManager.areaAttack(e, ee -> KnockBackHandler.setSmash(ee, 1.5)));
    public static final ComboState COMBO_A3_F = new ComboState("combo_a3_f", 100, () -> 90, () -> 120, () -> Float.valueOf(1.5f), () -> false, () -> 2000, DefaultResources.BaseMotionLocation, a -> NONE, () -> NONE);
    private static final EnumSet<InputCommand> combo_b1_alt = EnumSet.of(InputCommand.BACK, InputCommand.R_DOWN);
    public static final ComboState COMBO_B1 = new ComboState("combo_b1", 90, () -> 150, () -> 160, () -> Float.valueOf(1.0f), () -> false, () -> 1000, DefaultResources.BaseMotionLocation, a -> COMBO_B2, () -> COMBO_B1_F).setClickAction(e -> AttackManager.areaAttack(e, ee -> KnockBackHandler.setVertical(ee, 0.5))).addHoldAction(player -> {
        int elapsed = player.m_21252_();
        EnumSet commands = player.getCapability(INPUT_STATE).map(state -> state.getCommands((LivingEntity)player)).orElseGet(() -> EnumSet.noneOf(InputCommand.class));
        if (5 == elapsed && commands.containsAll(combo_b1_alt)) {
            Vec3 motion = player.m_20184_();
            player.m_20334_(motion.f_82479_, motion.f_82480_ + 0.7, motion.f_82481_);
            player.m_6853_(false);
            player.f_19812_ = true;
        }
    }).addHitEffect((e, a) -> StunManager.setStun(e, 15L)).addTickAction(playerIn -> FallHandler.fallDecrease(playerIn));
    public static final ComboState COMBO_B1_F = new ComboState("combo_b1_f", 100, () -> 165, () -> 185, () -> Float.valueOf(1.0f), () -> false, () -> 1000, DefaultResources.BaseMotionLocation, a -> NONE, () -> NONE).addTickAction(playerIn -> FallHandler.fallDecrease(playerIn));
    public static final ComboState COMBO_B2 = new ComboState("combo_b2", 90, () -> 200, () -> 215, () -> Float.valueOf(1.0f), () -> false, () -> 1000, DefaultResources.BaseMotionLocation, a -> NONE, () -> COMBO_B2_F).addHitEffect(StunManager::setStun).setClickAction(e -> AttackManager.areaAttack(e, ee -> KnockBackHandler.setVertical(ee, -5.0)));
    public static final ComboState COMBO_B2_F = new ComboState("combo_b2_f", 100, () -> 215, () -> 240, () -> Float.valueOf(1.0f), () -> false, () -> 1000, DefaultResources.BaseMotionLocation, a -> NONE, () -> NONE);
    public static final ComboState COMBO_AA1 = new ComboState("combo_aa1", 80, () -> 245, () -> 270, () -> Float.valueOf(1.0f), () -> false, () -> 500, DefaultResources.BaseMotionLocation, a -> COMBO_AA2, () -> COMBO_AA1_F).setClickAction(e -> AttackManager.areaAttack(e, KnockBackHandler::setCancel)).setIsAerial().addTickAction(playerIn -> {
        FallHandler.fallDecrease(playerIn);
        playerIn.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
            long elapsed = state.getElapsedTime((LivingEntity)playerIn);
            if (elapsed == 4L) {
                AttackManager.areaAttack(playerIn, KnockBackHandler::setCancel);
            }
        });
    }).addHitEffect(StunManager::setStun).setIsAerial();
    public static final ComboState COMBO_AA1_F = new ComboState("combo_aa1_f", 80, () -> 269, () -> 270, () -> Float.valueOf(20.0f), () -> true, () -> 1000, DefaultResources.BaseMotionLocation, a -> COMBO_AA2, () -> NONE);
    public static final ComboState COMBO_AA2 = new ComboState("combo_aa2", 80, () -> 270, () -> 295, () -> Float.valueOf(1.0f), () -> false, () -> 1000, DefaultResources.BaseMotionLocation, a -> NONE, () -> COMBO_AA2_F).setClickAction(e -> AttackManager.areaAttack(e, ee -> KnockBackHandler.setSmash(ee, 1.5))).setIsAerial().addTickAction(playerIn -> FallHandler.fallDecrease(playerIn));
    public static final ComboState COMBO_AA2_F = new ComboState("combo_aa2_f", 100, () -> 295, () -> 300, () -> Float.valueOf(1.0f), () -> false, () -> 400, DefaultResources.BaseMotionLocation, a -> NONE, () -> NONE).addTickAction(playerIn -> FallHandler.fallDecrease(playerIn));
    public static final ComboState ARTS_RAPID_SLASH = new ComboState("arts_rapid_slash", 70, () -> 80, () -> 90, () -> Float.valueOf(1.0f), () -> false, () -> 1000, DefaultResources.BaseMotionLocation, a -> ARTS_RAPID_SLASH_F, () -> ARTS_RAPID_SLASH_F).setClickAction(e -> AttackManager.areaAttack(e, KnockBackHandler::setCancel)).addHitEffect(StunManager::setStun).addHoldAction(playerIn -> {
        int elapsed = playerIn.m_21252_();
        if (elapsed < 6) {
            playerIn.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> AttackManager.areaAttack(playerIn, KnockBackHandler::setCancel, 1.0f, false, false, true));
            if (elapsed % 3 == 1) {
                playerIn.m_9236_().m_6263_((Player)null, playerIn.m_20185_(), playerIn.m_20186_(), playerIn.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 0.5f, 0.4f / (playerIn.m_217043_().m_188501_() * 0.4f + 0.8f));
            }
        }
        if (elapsed <= 3 && playerIn.m_20096_()) {
            playerIn.m_19920_(playerIn.m_20069_() ? 0.35f : 0.8f, new Vec3(0.0, 0.0, 1.0));
        }
        if (elapsed == 10 && (!playerIn.m_9236_().f_46443_ || playerIn.m_20096_())) {
            playerIn.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
                ComboState combo = ARTS_RISING_STAR;
                state.setComboSeq(combo);
                state.setLastActionTime(playerIn.m_9236_().m_46467_());
                combo.clickAction((LivingEntity)playerIn);
            });
        }
    });
    public static final ComboState ARTS_RAPID_SLASH_F = new ComboState("arts_rapid_slash_f", 70, () -> 90, () -> 120, () -> Float.valueOf(1.0f), () -> false, () -> 1000, DefaultResources.BaseMotionLocation, a -> NONE, () -> NONE);
    public static final ComboState ARTS_RISING_STAR = new ComboState("arts_rising_star", 100, () -> 250, () -> 255, () -> Float.valueOf(0.75f), () -> false, () -> 1000, DefaultResources.BaseMotionLocation, a -> NONE, () -> COMBO_A3_F).addHitEffect(StunManager::setStun).setIsAerial().setClickAction(playerIn -> {
        AttackManager.areaAttack(playerIn, ee -> KnockBackHandler.setVertical(ee, 0.5), 1.0f, true, false, false);
        Vec3 motion = playerIn.m_20184_();
        playerIn.m_20334_(0.0, motion.f_82480_ + 0.7, 0.0);
        playerIn.m_6853_(false);
        playerIn.f_19812_ = true;
    }).addHoldAction(playerIn -> {
        int elapsed = playerIn.m_21252_();
        if (elapsed < 6) {
            playerIn.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> AttackManager.areaAttack(playerIn, ee -> KnockBackHandler.setVertical(ee, 0.5), 1.0f, false, false, true));
            if (elapsed % 2 == 1) {
                playerIn.m_9236_().m_6263_((Player)null, playerIn.m_20185_(), playerIn.m_20186_(), playerIn.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 0.5f, 0.4f / (playerIn.m_217043_().m_188501_() * 0.4f + 0.8f));
            }
        }
    }).addTickAction(playerIn -> FallHandler.fallDecrease(playerIn));
    public static final ComboState ARTS_HELM_BREAKER = new ComboState("arts_helm_breaker", 70, () -> 200, () -> 215, () -> Float.valueOf(1.0f), () -> false, () -> 1000, DefaultResources.BaseMotionLocation, a -> NONE, () -> ARTS_HELM_BREAKER_F).addHitEffect(StunManager::setStun).setClickAction(playerIn -> {
        AttackManager.areaAttack(playerIn, KnockBacks.meteor.action, 1.0f, true, false, false);
        Vec3 motion = playerIn.m_20184_();
        playerIn.m_20334_(motion.f_82479_, motion.f_82480_ - 0.7, motion.f_82481_);
    }).addHoldAction(playerIn -> {
        int elapsed = playerIn.m_21252_();
        if (!playerIn.m_20096_()) {
            playerIn.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> AttackManager.areaAttack(playerIn, ee -> KnockBackHandler.setVertical(ee, -5.0), 1.0f, false, false, true));
            if (elapsed % 2 == 1) {
                playerIn.m_9236_().m_6263_((Player)null, playerIn.m_20185_(), playerIn.m_20186_(), playerIn.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 0.5f, 0.4f / (playerIn.m_217043_().m_188501_() * 0.4f + 0.8f));
            }
        }
    }).addTickAction(playerIn -> {
        if (!playerIn.m_20096_()) {
            playerIn.f_19789_ = 1.0f;
        } else {
            playerIn.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
                AttackManager.areaAttack(playerIn, ee -> KnockBackHandler.setVertical(ee, -5.0), 1.3f, true, true, true);
                state.setComboSeq(ARTS_HELM_BREAKER_F);
                state.setLastActionTime(playerIn.m_9236_().m_46467_());
                FallHandler.spawnLandingParticle(playerIn, 20.0f);
            });
        }
    });
    public static final ComboState ARTS_HELM_BREAKER_F = new ComboState("arts_helm_breaker_f", 70, () -> 214, () -> 215, () -> Float.valueOf(20.0f), () -> true, () -> 600, DefaultResources.BaseMotionLocation, a -> NONE, () -> COMBO_B2_F);
    static final EnumSet<InputCommand> jc_cycle_input = EnumSet.of(InputCommand.L_DOWN, InputCommand.R_CLICK);
    static final RangeMap<Long, SlashArts.ArtsType> jc_cycle_accept = ImmutableRangeMap.builder().put(Range.lessThan((Comparable)Long.valueOf(7L)), (Object)SlashArts.ArtsType.Fail).put(Range.closedOpen((Comparable)Long.valueOf(7L), (Comparable)Long.valueOf(8L)), (Object)SlashArts.ArtsType.Jackpot).put(Range.closed((Comparable)Long.valueOf(8L), (Comparable)Long.valueOf(9L)), (Object)SlashArts.ArtsType.Success).put(Range.greaterThan((Comparable)Long.valueOf(9L)), (Object)SlashArts.ArtsType.Fail).build();
    public static final ComboState SLASH_ARTS_JC = new ComboState("slash_arts_jc", 50, () -> 115, () -> 120, () -> Float.valueOf(0.5f), () -> false, () -> 600, DefaultResources.BaseMotionLocation, a -> {
        EnumSet commands = a.getCapability(INPUT_STATE).map(state -> state.getCommands((LivingEntity)a)).orElseGet(() -> EnumSet.noneOf(InputCommand.class));
        if (commands.containsAll(jc_cycle_input)) {
            return a.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).map(s -> {
                long time = a.m_9236_().m_46467_();
                long lastAction = s.getLastActionTime();
                long count = time - lastAction;
                SlashArts.ArtsType type = (SlashArts.ArtsType)((Object)((Object)((Object)jc_cycle_accept.get((Comparable)Long.valueOf(count)))));
                return s.getSlashArts().doArts(type, (LivingEntity)a);
            }).orElse(NONE);
        }
        return NONE;
    }, () -> NONE).addTickAction(playerIn -> FallHandler.fallResist(playerIn)).addTickAction(TimeLineTickAction.getBuilder().put(0, JudgementCut::doJudgementCut).build());
    public static ComboState ExtraStandBy = Extra.STANDBY_EX;
    private ResourceLocation motionLoc;
    private Supplier<Integer> start;
    private Supplier<Integer> end;
    private Supplier<Float> speed;
    private Supplier<Boolean> loop;
    public Supplier<Integer> timeout;
    private Function<LivingEntity, ComboState> next;
    private Supplier<ComboState> nextOfTimeout;
    private Consumer<LivingEntity> holdAction;
    private Consumer<LivingEntity> tickAction;
    private BiConsumer<LivingEntity, LivingEntity> hitEffect;
    private Consumer<LivingEntity> clickAction;
    private BiFunction<LivingEntity, Integer, SlashArts.ArtsType> releaseAction;
    private boolean isAerial;
    private int priority;

    @Override
    public Map<ResourceLocation, ComboState> getRegistry() {
        return registry;
    }

    public ResourceLocation getMotionLoc() {
        return this.motionLoc;
    }

    public int getStartFrame() {
        return this.start.get();
    }

    public int getEndFrame() {
        return this.end.get();
    }

    public float getSpeed() {
        return this.speed.get().floatValue();
    }

    public boolean getLoop() {
        return this.loop.get();
    }

    public int getTimeoutMS() {
        return (int)(TimeValueHelper.getMSecFromFrames(Math.abs(this.getEndFrame() - this.getStartFrame())) / (double)this.getSpeed()) + this.timeout.get();
    }

    public void holdAction(LivingEntity user) {
        this.holdAction.accept(user);
    }

    public ComboState addHoldAction(Consumer<LivingEntity> holdAction) {
        this.holdAction = this.holdAction.andThen(holdAction);
        return this;
    }

    public void tickAction(LivingEntity user) {
        this.tickAction.accept(user);
    }

    public ComboState addTickAction(Consumer<LivingEntity> tickAction) {
        this.tickAction = this.tickAction.andThen(tickAction);
        return this;
    }

    public void hitEffect(LivingEntity target, LivingEntity attacker) {
        this.hitEffect.accept(target, attacker);
    }

    public ComboState addHitEffect(BiConsumer<LivingEntity, LivingEntity> hitEffect) {
        this.hitEffect = this.hitEffect.andThen(hitEffect);
        return this;
    }

    public void clickAction(LivingEntity user) {
        this.clickAction.accept(user);
    }

    public ComboState setClickAction(Consumer<LivingEntity> clickAction) {
        this.clickAction = clickAction;
        return this;
    }

    public SlashArts.ArtsType releaseAction(LivingEntity user, int elapsed) {
        return this.releaseAction.apply(user, elapsed);
    }

    public ComboState setReleaseAction(BiFunction<LivingEntity, Integer, SlashArts.ArtsType> clickAction) {
        this.releaseAction = clickAction;
        return this;
    }

    public ComboState(String name, int priority, Supplier<Integer> start, Supplier<Integer> end, Supplier<Float> speed, Supplier<Boolean> loop, Supplier<Integer> timeout, ResourceLocation motionLoc, Function<LivingEntity, ComboState> next, Supplier<ComboState> nextOfTimeout) {
        super(name);
        this.start = start;
        this.end = end;
        this.speed = speed;
        this.timeout = timeout;
        this.loop = loop;
        this.motionLoc = motionLoc;
        this.next = next;
        this.nextOfTimeout = nextOfTimeout;
        this.holdAction = a -> {};
        this.tickAction = ArrowReflector::doTicks;
        this.hitEffect = (a, b) -> {};
        this.clickAction = user -> {};
        this.releaseAction = (u, e) -> SlashArts.ArtsType.Fail;
        this.isAerial = false;
        this.priority = priority;
    }

    @Override
    public String getPath() {
        return "combostate";
    }

    @Override
    public ComboState getNone() {
        return NONE;
    }

    public ComboState getNext(LivingEntity living) {
        return this.next.apply(living);
    }

    public ComboState getNextOfTimeout() {
        return this.nextOfTimeout.get();
    }

    @Nonnull
    public ComboState checkTimeOut(float msec) {
        return (float)this.getTimeoutMS() < msec ? this.nextOfTimeout.get() : this;
    }

    public boolean isAerial() {
        return this.isAerial;
    }

    public ComboState setIsAerial() {
        this.isAerial = true;
        return this;
    }

    public int getPriority() {
        return this.priority;
    }

    public static SlashArts.ArtsType releaseActionQuickCharge(LivingEntity user, Integer elapsed) {
        int level = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44976_, (LivingEntity)user);
        if (elapsed <= 3 + level) {
            AdvancementHelper.grantedIf(Enchantments.f_44976_, user);
            AdvancementHelper.grantCriterion(user, Extra.ADVANCEMENT_QUICK_CHARGE);
            return SlashArts.ArtsType.Jackpot;
        }
        return SlashArts.ArtsType.Fail;
    }

    public static long getElapsed(LivingEntity livingEntity) {
        return livingEntity.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).map(state -> state.getElapsedTime(livingEntity)).orElseGet(() -> 0L);
    }

    public static class TimeLineTickAction
    implements Consumer<LivingEntity> {
        long offset = -1L;
        Map<Integer, Consumer<LivingEntity>> timeLine = Maps.newHashMap();

        public static TimeLineTickActionBuilder getBuilder() {
            return new TimeLineTickActionBuilder();
        }

        TimeLineTickAction(Map<Integer, Consumer<LivingEntity>> timeLine) {
            this.timeLine.putAll(timeLine);
        }

        @Override
        public void accept(LivingEntity livingEntity) {
            long elapsed = ComboState.getElapsed(livingEntity);
            if (this.offset < 0L) {
                this.offset = elapsed;
            }
            Consumer<LivingEntity> action = this.timeLine.getOrDefault((int)(elapsed -= this.offset), this::defaultConsumer);
            action.accept(livingEntity);
        }

        void defaultConsumer(LivingEntity entityIn) {
        }

        public static class TimeLineTickActionBuilder {
            Map<Integer, Consumer<LivingEntity>> timeLine = Maps.newHashMap();

            public TimeLineTickActionBuilder put(int ticks, Consumer<LivingEntity> action) {
                this.timeLine.put(ticks, action);
                return this;
            }

            public TimeLineTickAction build() {
                return new TimeLineTickAction(this.timeLine);
            }
        }
    }

    public static class TimeoutNext
    implements Function<LivingEntity, ComboState> {
        long timeout;
        Function<LivingEntity, ComboState> next;

        public static TimeoutNext buildFromFrame(int timeoutFrame, Function<LivingEntity, ComboState> next) {
            return new TimeoutNext((int)TimeValueHelper.getTicksFromFrames(timeoutFrame), next);
        }

        public TimeoutNext(long timeout, Function<LivingEntity, ComboState> next) {
            this.timeout = timeout;
            this.next = next;
        }

        @Override
        public ComboState apply(LivingEntity livingEntity) {
            long elapsed = ComboState.getElapsed(livingEntity);
            if (this.timeout <= elapsed) {
                return this.next.apply(livingEntity);
            }
            return livingEntity.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).map(state -> state.getComboSeq()).orElseGet(() -> NONE);
        }
    }
}

