/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.utils.FacingUtils;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.blocks.Portal;
import com.brandon3055.draconicevolution.blocks.tileentity.TileDislocatorReceptacle;
import com.brandon3055.draconicevolution.blocks.tileentity.TilePortal;
import com.brandon3055.draconicevolution.init.DEContent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class PortalHelper {
    private TileDislocatorReceptacle tile;
    private boolean scanning = false;
    private boolean building = false;
    private Map<Direction.Axis, Set<BlockPos>> invalidBlocks = null;
    private Map<Direction.Axis, Set<BlockPos>> scanResult = null;
    private Map<Direction.Axis, List<BlockPos>> scanQue = null;
    private Map<Direction.Axis, LinkedList<BlockPos>> originQue = null;
    public int scanIndex = -1;
    private LinkedList<BlockPos> buildList = null;
    private Set<BlockPos> builtList = null;
    private Direction.Axis buildAxis = null;

    public PortalHelper(TileDislocatorReceptacle tile) {
        this.tile = tile;
    }

    public void startScan() {
        if (this.scanning) {
            return;
        }
        this.scanQue = new HashMap<Direction.Axis, List<BlockPos>>();
        this.originQue = new HashMap<Direction.Axis, LinkedList<BlockPos>>();
        this.invalidBlocks = new HashMap<Direction.Axis, Set<BlockPos>>();
        this.scanResult = new HashMap<Direction.Axis, Set<BlockPos>>();
        this.scanning = true;
        ++this.scanIndex;
        this.initScan();
    }

    public void updateTick() {
        if (this.scanning) {
            boolean hasWork = false;
            for (Direction.Axis axis : Direction.Axis.values()) {
                if (!this.scanning) continue;
                this.updateAxis(axis);
                if ((this.scanResult == null || this.scanResult.get(axis) == null) && (this.scanQue == null || this.scanQue.isEmpty())) continue;
                hasWork = true;
            }
            if (this.scanning && !hasWork) {
                this.endScan(false, null, null);
            }
        } else if (this.building) {
            this.updateBuildTick();
        }
    }

    private void updateAxis(Direction.Axis axis) {
        if (!this.preScanCheck(axis)) {
            return;
        }
        Set<BlockPos> invalidBlocks = this.invalidBlocks.get(axis);
        Set<BlockPos> scanResult = this.scanResult.get(axis);
        List<BlockPos> scanQue = this.scanQue.get(axis);
        if (scanQue.isEmpty()) {
            this.endScan(true, scanResult, axis);
            return;
        }
        BlockPos pos = scanQue.remove(this.tile.m_58904_().f_46441_.m_188503_(scanQue.size()));
        this.tile.onScanBlock(pos);
        for (Direction dir : FacingUtils.getFacingsAroundAxis((Direction.Axis)axis)) {
            BlockPos newPos = pos.m_121945_(dir);
            if (scanResult.contains(newPos) || this.tile.m_58904_().m_151570_(newPos)) continue;
            if (invalidBlocks.contains(newPos) || newPos.m_123331_((Vec3i)this.tile.m_58899_()) > (double)DEConfig.portalMaxDistanceSq) {
                this.endPass(axis);
                return;
            }
            if (!this.tile.m_58904_().m_46749_(newPos)) {
                this.endPass(axis);
                return;
            }
            if (this.isAir(newPos)) {
                scanQue.add(newPos);
                scanResult.add(newPos);
                if (scanResult.size() <= DEConfig.portalMaxArea) continue;
                this.endPass(axis);
                return;
            }
            if (this.isFrame(newPos)) continue;
            this.endPass(axis);
            return;
        }
    }

    private boolean preScanCheck(Direction.Axis axis) {
        Set<BlockPos> invalidBlocks = this.invalidBlocks.get(axis);
        Set<BlockPos> scanResult = this.scanResult.get(axis);
        List<BlockPos> scanQue = this.scanQue.get(axis);
        LinkedList<BlockPos> originQue = this.originQue.get(axis);
        if (scanResult == null) {
            if (originQue.isEmpty()) {
                return false;
            }
            BlockPos scanOrigin = originQue.pollFirst();
            if (invalidBlocks.contains(scanOrigin)) {
                return false;
            }
            scanResult = new HashSet<BlockPos>();
            scanQue.clear();
            scanQue.add(scanOrigin);
            scanResult.add(scanOrigin);
            this.scanResult.put(axis, scanResult);
        }
        return true;
    }

    private void initScan() {
        for (Direction.Axis axis : Direction.Axis.values()) {
            BlockPos[] offsets;
            this.invalidBlocks.put(axis, new HashSet());
            this.scanQue.put(axis, new ArrayList());
            this.originQue.put(axis, new LinkedList());
            LinkedList<BlockPos> originQue = this.originQue.get(axis);
            for (BlockPos offset : offsets = FacingUtils.getAroundAxis((Direction.Axis)axis)) {
                BlockPos pos = this.tile.m_58899_().m_121955_((Vec3i)offset);
                if (!this.isAir(pos)) continue;
                originQue.add(pos);
            }
        }
    }

    private void endPass(Direction.Axis axis) {
        this.invalidBlocks.get(axis).addAll((Collection<BlockPos>)this.scanResult.get(axis));
        this.scanResult.put(axis, null);
    }

    private void endScan(boolean successful, Set<BlockPos> result, Direction.Axis axis) {
        this.scanning = false;
        this.scanQue = null;
        this.originQue = null;
        this.invalidBlocks = null;
        this.tile.onScanComplete(successful ? result : null, axis);
        this.scanResult = null;
    }

    public boolean isRunning() {
        return this.scanning || this.building;
    }

    private boolean isAir(BlockPos pos) {
        if (this.tile.m_58904_().m_46859_(pos)) {
            return true;
        }
        BlockEntity te = this.tile.m_58904_().m_7702_(pos);
        return te instanceof TilePortal && ((TilePortal)te).getControllerPos().equals((Object)this.tile.m_58899_());
    }

    private boolean isFrame(BlockPos pos) {
        return pos.equals((Object)this.tile.m_58899_()) || this.tile.m_58904_().m_8055_(pos).m_60713_((Block)DEContent.INFUSED_OBSIDIAN.get());
    }

    public void abort() {
        if (this.scanning) {
            this.endScan(false, null, null);
        }
        if (this.building) {
            this.endBuild(false);
        }
    }

    public void buildPortal(Set<BlockPos> portalShape, Direction.Axis axis) {
        this.building = true;
        this.buildList = new LinkedList();
        this.builtList = new HashSet<BlockPos>();
        this.buildAxis = axis;
        Vector3 min = new Vector3().set(6.0E7);
        Vector3 max = new Vector3().set(-6.0E7);
        for (BlockPos pos2 : portalShape) {
            if ((double)pos2.m_123341_() < min.x) {
                min.x = pos2.m_123341_();
            }
            if ((double)pos2.m_123342_() < min.y) {
                min.y = pos2.m_123342_();
            }
            if ((double)pos2.m_123343_() < min.z) {
                min.z = pos2.m_123343_();
            }
            if ((double)pos2.m_123341_() > max.x) {
                max.x = pos2.m_123341_();
            }
            if ((double)pos2.m_123342_() > max.y) {
                max.y = pos2.m_123342_();
            }
            if (!((double)pos2.m_123343_() > max.z)) continue;
            max.z = pos2.m_123343_();
        }
        BlockPos mid = min.copy().add(max.subtract(min).divide(2.0)).pos();
        this.buildList.addAll(((Stream)portalShape.stream().parallel()).sorted(Comparator.comparing(pos -> pos.m_123331_((Vec3i)mid))).collect(Collectors.toList()));
    }

    private void updateBuildTick() {
        if (this.buildList.isEmpty()) {
            this.endBuild(true);
            return;
        }
        BlockPos nextPos = this.buildList.pollLast();
        if (!this.isAir(nextPos)) {
            this.endBuild(false);
            return;
        }
        BlockState portalState = (BlockState)((Portal)((Object)DEContent.PORTAL.get())).m_49966_().m_61124_(Portal.AXIS, (Comparable)this.buildAxis);
        this.tile.m_58904_().m_46597_(nextPos, Portal.getPlacementState(portalState, this.tile.m_58904_(), nextPos));
        this.builtList.add(nextPos);
        BlockEntity placedTile = this.tile.m_58904_().m_7702_(nextPos);
        if (!(placedTile instanceof TilePortal)) {
            this.endBuild(false);
            return;
        }
        ((TilePortal)placedTile).setControllerPos(this.tile.m_58899_());
    }

    private void endBuild(boolean successful) {
        this.building = false;
        this.buildList = null;
        if (successful) {
            this.tile.onBuildSuccess(new ArrayList<BlockPos>(this.builtList));
        } else {
            this.tile.onBuildFail();
            for (BlockPos pos : this.builtList) {
                BlockState state = this.tile.m_58904_().m_8055_(pos);
                if (!state.m_60713_((Block)DEContent.PORTAL.get())) continue;
                this.tile.m_58904_().m_7471_(pos, false);
            }
        }
        this.builtList = null;
    }

    public boolean isBuilding() {
        return this.building;
    }
}

