/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.atlas;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class MultiModAtlasHolder
implements PreparableReloadListener,
AutoCloseable {
    private final TextureAtlas textureAtlas;
    private final ResourceLocation atlasLocation;
    private final ResourceLocation atlasInfoLocation;
    private final Set<String> modIds;

    public MultiModAtlasHolder(String hostModId, String atlasLocation, String atlasInfoLocation, Set<String> modIds) {
        this.modIds = modIds;
        this.atlasInfoLocation = new ResourceLocation(hostModId, atlasInfoLocation);
        this.atlasLocation = new ResourceLocation(hostModId, atlasLocation);
        this.textureAtlas = new TextureAtlas(this.atlasLocation);
        Minecraft.m_91087_().m_91097_().m_118495_(this.textureAtlas.m_118330_(), (AbstractTexture)this.textureAtlas);
    }

    public ResourceLocation atlasLocation() {
        return this.atlasLocation;
    }

    public TextureAtlasSprite getSprite(ResourceLocation resourceLocation) {
        return this.textureAtlas.m_118316_(resourceLocation);
    }

    @NotNull
    public final CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier prepBarrier, ResourceManager resourceManager, ProfilerFiller profiler, ProfilerFiller profiler2, Executor executor, Executor executor2) {
        Objects.requireNonNull(prepBarrier);
        SpriteLoader spriteLoader = SpriteLoader.m_245483_((TextureAtlas)this.textureAtlas);
        return ((CompletableFuture)((CompletableFuture)spriteLoader.m_260881_((ResourceManager)new ModResourceManager(resourceManager), this.atlasInfoLocation, 0, executor).thenCompose(SpriteLoader.Preparations::m_246429_)).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)prepBarrier).m_6769_(arg_0))).thenAcceptAsync(preparations -> this.apply((SpriteLoader.Preparations)preparations, profiler2), executor2);
    }

    private void apply(SpriteLoader.Preparations preparations, ProfilerFiller profilerFiller) {
        profilerFiller.m_7242_();
        profilerFiller.m_6180_("upload");
        this.textureAtlas.m_247065_(preparations);
        profilerFiller.m_7238_();
        profilerFiller.m_7241_();
    }

    @Override
    public void close() {
        this.textureAtlas.m_118329_();
    }

    public class ModResourceManager
    implements ResourceManager {
        private final ResourceManager wrapped;

        public ModResourceManager(ResourceManager wrapped) {
            this.wrapped = wrapped;
        }

        public Map<ResourceLocation, Resource> m_214159_(String pPath, Predicate<ResourceLocation> pFilter) {
            return this.wrapped.m_214159_(pPath, pFilter.and(e -> MultiModAtlasHolder.this.modIds.contains(e.m_135827_())));
        }

        public Set<String> m_7187_() {
            return this.wrapped.m_7187_();
        }

        public List<Resource> m_213829_(ResourceLocation pLocation) {
            return this.wrapped.m_213829_(pLocation);
        }

        public Map<ResourceLocation, List<Resource>> m_214160_(String pPath, Predicate<ResourceLocation> pFilter) {
            return this.wrapped.m_214160_(pPath, pFilter);
        }

        public Stream<PackResources> m_7536_() {
            return this.wrapped.m_7536_();
        }

        public Optional<Resource> m_213713_(ResourceLocation pLocation) {
            return this.wrapped.m_213713_(pLocation);
        }
    }
}

