/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tiviacz.travelersbackpack.client.model.BackpackLayerDefinition;
import com.tiviacz.travelersbackpack.client.renderer.RenderData;
import com.tiviacz.travelersbackpack.common.recipes.BackpackDyeRecipe;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackContainer;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.RenderUtils;
import java.util.Locale;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import org.apache.commons.lang3.tuple.Triple;

public class BackpackBlockModel {
    public static final BackpackBlockModel BLOCK_MODEL = new BackpackBlockModel(BackpackLayerDefinition.createTravelersBackpack(false).m_171564_());
    public ModelPart mainBody;
    public ModelPart tankLeftTop;
    public ModelPart tankRightTop;
    public ModelPart sleepingBag;
    public ModelPart sleepingBagExtras;
    public ModelPart villagerNose;
    public ModelPart wolfNose;
    public ModelPart foxNose;
    public ModelPart ocelotNose;
    public ModelPart pigNose;

    public BackpackBlockModel(ModelPart rootPart) {
        this.mainBody = rootPart.m_171324_("main_body");
        this.tankLeftTop = rootPart.m_171324_("tankLeftTop");
        this.tankRightTop = rootPart.m_171324_("tankRightTop");
        this.sleepingBag = rootPart.m_171324_("sleepingBag");
        this.sleepingBagExtras = rootPart.m_171324_("sleepingBagExtras");
        this.villagerNose = rootPart.m_171324_("villagerNose");
        this.ocelotNose = rootPart.m_171324_("ocelotNose");
        this.pigNose = rootPart.m_171324_("pigNose");
        this.foxNose = rootPart.m_171324_("foxNose");
        this.wolfNose = rootPart.m_171324_("wolfNose");
    }

    public void render(ITravelersBackpackContainer container, PoseStack poseStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        Item item = container.getItemStack().m_41720_();
        if (!(item instanceof TravelersBackpackItem)) {
            return;
        }
        TravelersBackpackItem travelersBackpackItem = (TravelersBackpackItem)item;
        ResourceLocation loc = travelersBackpackItem.getBackpackTexture();
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)loc));
        if (travelersBackpackItem == ModItems.STANDARD_TRAVELERS_BACKPACK.get() && container.hasBlockEntity() ? container.hasColor() : BackpackDyeRecipe.hasColor(container.getItemStack())) {
            loc = new ResourceLocation("travelersbackpack", "textures/model/dyed.png");
            Triple<Float, Float, Float> rgb = RenderUtils.intToRGB(container.hasBlockEntity() ? container.getColor() : BackpackDyeRecipe.getColor(container.getItemStack()));
            vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)loc));
            this.mainBody.m_104306_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn, ((Float)rgb.getLeft()).floatValue(), ((Float)rgb.getMiddle()).floatValue(), ((Float)rgb.getRight()).floatValue(), 1.0f);
            loc = new ResourceLocation("travelersbackpack", "textures/model/dyed_extras.png");
            vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)loc));
            this.mainBody.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            this.tankLeftTop.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            this.tankRightTop.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            if (!container.isSleepingBagDeployed()) {
                this.sleepingBagExtras.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
                loc = BackpackBlockModel.getSleepingBagTexture(container.getSleepingBagColor());
                vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)loc));
                this.sleepingBag.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
        } else {
            this.tankLeftTop.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            this.tankRightTop.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            if (!container.isSleepingBagDeployed()) {
                this.sleepingBagExtras.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
                loc = BackpackBlockModel.getSleepingBagTexture(container.getSleepingBagColor());
                vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)loc));
                this.sleepingBag.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
                loc = travelersBackpackItem.getBackpackTexture();
                vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)loc));
            }
            if (container.getItemStack().m_41720_() == ModItems.FOX_TRAVELERS_BACKPACK.get()) {
                this.foxNose.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
            if (container.getItemStack().m_41720_() == ModItems.OCELOT_TRAVELERS_BACKPACK.get()) {
                this.ocelotNose.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
            if (container.getItemStack().m_41720_() == ModItems.WOLF_TRAVELERS_BACKPACK.get()) {
                this.wolfNose.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
            if (container.getItemStack().m_41720_() == ModItems.VILLAGER_TRAVELERS_BACKPACK.get() || container.getItemStack().m_41720_() == ModItems.IRON_GOLEM_TRAVELERS_BACKPACK.get()) {
                this.villagerNose.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
            if (container.getItemStack().m_41720_() == ModItems.PIG_TRAVELERS_BACKPACK.get() || container.getItemStack().m_41720_() == ModItems.HORSE_TRAVELERS_BACKPACK.get()) {
                this.pigNose.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
            if (container.getItemStack().m_41720_() == ModItems.QUARTZ_TRAVELERS_BACKPACK.get() || container.getItemStack().m_41720_() == ModItems.SNOW_TRAVELERS_BACKPACK.get()) {
                vertexConsumer = buffer.m_6299_(container.hasBlockEntity() ? RenderType.m_110470_((ResourceLocation)travelersBackpackItem.getBackpackTexture()) : RenderType.m_110467_((ResourceLocation)travelersBackpackItem.getBackpackTexture()));
            }
            this.mainBody.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
        }
        RenderUtils.renderFluidInTank(container, container.getLeftTank(), poseStack, buffer, combinedLightIn, -0.65f, -0.565f, -0.24f);
        RenderUtils.renderFluidInTank(container, container.getRightTank(), poseStack, buffer, combinedLightIn, 0.23f, -0.565f, -0.24f);
    }

    public void renderByItem(RenderData renderData, PoseStack poseStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        TravelersBackpackItem travelersBackpackItem = (TravelersBackpackItem)renderData.getItemStack().m_41720_();
        ResourceLocation loc = travelersBackpackItem.getBackpackTexture();
        VertexConsumer ivertexbuilder = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)loc));
        if (BackpackDyeRecipe.hasColor(renderData.getItemStack()) && renderData.getItemStack().m_41720_() == ModItems.STANDARD_TRAVELERS_BACKPACK.get()) {
            loc = new ResourceLocation("travelersbackpack", "textures/model/dyed.png");
            Triple<Float, Float, Float> rgb = RenderUtils.intToRGB(BackpackDyeRecipe.getColor(renderData.getItemStack()));
            ivertexbuilder = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)loc));
            this.mainBody.m_104306_(poseStack, ivertexbuilder, combinedLightIn, combinedOverlayIn, ((Float)rgb.getLeft()).floatValue(), ((Float)rgb.getMiddle()).floatValue(), ((Float)rgb.getRight()).floatValue(), 1.0f);
            loc = new ResourceLocation("travelersbackpack", "textures/model/dyed_extras.png");
            ivertexbuilder = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)loc));
            this.mainBody.m_104301_(poseStack, ivertexbuilder, combinedLightIn, combinedOverlayIn);
            this.tankLeftTop.m_104301_(poseStack, ivertexbuilder, combinedLightIn, combinedOverlayIn);
            this.tankRightTop.m_104301_(poseStack, ivertexbuilder, combinedLightIn, combinedOverlayIn);
            this.sleepingBagExtras.m_104301_(poseStack, ivertexbuilder, combinedLightIn, combinedOverlayIn);
            loc = BackpackBlockModel.getSleepingBagTexture(renderData.getSleepingBagColor());
            ivertexbuilder = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)loc));
            this.sleepingBag.m_104301_(poseStack, ivertexbuilder, combinedLightIn, combinedOverlayIn);
        } else {
            this.tankLeftTop.m_104301_(poseStack, ivertexbuilder, combinedLightIn, combinedOverlayIn);
            this.tankRightTop.m_104301_(poseStack, ivertexbuilder, combinedLightIn, combinedOverlayIn);
            this.sleepingBagExtras.m_104301_(poseStack, ivertexbuilder, combinedLightIn, combinedOverlayIn);
            loc = BackpackBlockModel.getSleepingBagTexture(renderData.getSleepingBagColor());
            ivertexbuilder = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)loc));
            this.sleepingBag.m_104301_(poseStack, ivertexbuilder, combinedLightIn, combinedOverlayIn);
            loc = travelersBackpackItem.getBackpackTexture();
            ivertexbuilder = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)loc));
            if (renderData.getItemStack().m_41720_() == ModItems.FOX_TRAVELERS_BACKPACK.get()) {
                this.foxNose.m_104301_(poseStack, ivertexbuilder, combinedLightIn, combinedOverlayIn);
            }
            if (renderData.getItemStack().m_41720_() == ModItems.OCELOT_TRAVELERS_BACKPACK.get()) {
                this.ocelotNose.m_104301_(poseStack, ivertexbuilder, combinedLightIn, combinedOverlayIn);
            }
            if (renderData.getItemStack().m_41720_() == ModItems.WOLF_TRAVELERS_BACKPACK.get()) {
                this.wolfNose.m_104301_(poseStack, ivertexbuilder, combinedLightIn, combinedOverlayIn);
            }
            if (renderData.getItemStack().m_41720_() == ModItems.VILLAGER_TRAVELERS_BACKPACK.get() || renderData.getItemStack().m_41720_() == ModItems.IRON_GOLEM_TRAVELERS_BACKPACK.get()) {
                this.villagerNose.m_104301_(poseStack, ivertexbuilder, combinedLightIn, combinedOverlayIn);
            }
            if (renderData.getItemStack().m_41720_() == ModItems.PIG_TRAVELERS_BACKPACK.get() || renderData.getItemStack().m_41720_() == ModItems.HORSE_TRAVELERS_BACKPACK.get()) {
                this.pigNose.m_104301_(poseStack, ivertexbuilder, combinedLightIn, combinedOverlayIn);
            }
            if (renderData.getItemStack().m_41720_() == ModItems.QUARTZ_TRAVELERS_BACKPACK.get() || renderData.getItemStack().m_41720_() == ModItems.SNOW_TRAVELERS_BACKPACK.get()) {
                ivertexbuilder = buffer.m_6299_(RenderType.m_110467_((ResourceLocation)travelersBackpackItem.getBackpackTexture()));
            }
            this.mainBody.m_104301_(poseStack, ivertexbuilder, combinedLightIn, combinedOverlayIn);
        }
        RenderUtils.renderFluidInTank(null, renderData.getLeftTank(), poseStack, buffer, combinedLightIn, -0.65f, -0.565f, -0.24f);
        RenderUtils.renderFluidInTank(null, renderData.getRightTank(), poseStack, buffer, combinedLightIn, 0.23f, -0.565f, -0.24f);
    }

    public static ResourceLocation getSleepingBagTexture(int color) {
        return new ResourceLocation("travelersbackpack", "textures/model/bags/" + DyeColor.m_41053_((int)color).m_41065_().toLowerCase(Locale.ENGLISH) + "_sleeping_bag.png");
    }
}

