/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.client.shader;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.shaders.Program;
import com.mojang.blaze3d.shaders.Shader;
import com.mojang.blaze3d.vertex.VertexFormat;
import committee.nova.mods.avaritia.api.client.shader.CCUniform;
import committee.nova.mods.avaritia.api.client.shader.GlslProcessor;
import committee.nova.mods.avaritia.api.client.shader.UniformType;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ChainedJsonException;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL20;

public class CCShaderInstance
extends ShaderInstance {
    private final List<Runnable> applyCallbacks = new LinkedList<Runnable>();

    protected CCShaderInstance(ResourceProvider resourceProvider, ResourceLocation loc, VertexFormat format) throws IOException {
        super(resourceProvider, loc, format);
    }

    public static CCShaderInstance create(ResourceProvider resourceProvider, ResourceLocation loc, VertexFormat format) {
        try {
            return new CCShaderInstance(resourceProvider, loc, format);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to initialize shader.", ex);
        }
    }

    public void onApply(Runnable callback) {
        this.applyCallbacks.add(callback);
    }

    public void m_173363_() {
        for (Runnable callback : this.applyCallbacks) {
            callback.run();
        }
        super.m_173363_();
    }

    @Nullable
    public CCUniform getUniform(@NotNull String name) {
        return (CCUniform)super.m_173348_(name);
    }

    protected void m_173354_(@NotNull JsonElement json) throws ChainedJsonException {
        JsonObject obj = GsonHelper.m_13918_((JsonElement)json, (String)"uniform");
        String name = GsonHelper.m_13906_((JsonObject)obj, (String)"name");
        String typeStr = GsonHelper.m_13906_((JsonObject)obj, (String)"type");
        UniformType type = UniformType.parse(typeStr);
        if (type == null) {
            throw new ChainedJsonException("Invalid type '%s'. See UniformType enum. All vanilla types supported.".formatted(typeStr));
        }
        int count = GsonHelper.m_13927_((JsonObject)obj, (String)"count");
        block0 : switch (type) {
            case FLOAT: {
                switch (count) {
                    case 2: {
                        type = UniformType.VEC2;
                        break;
                    }
                    case 3: {
                        type = UniformType.VEC3;
                        break;
                    }
                    case 4: {
                        type = UniformType.VEC4;
                    }
                }
                break;
            }
            case INT: {
                switch (count) {
                    case 2: {
                        type = UniformType.I_VEC2;
                        break;
                    }
                    case 3: {
                        type = UniformType.I_VEC3;
                        break;
                    }
                    case 4: {
                        type = UniformType.I_VEC4;
                    }
                }
                break;
            }
            case U_INT: {
                switch (count) {
                    case 2: {
                        type = UniformType.U_VEC2;
                        break block0;
                    }
                    case 3: {
                        type = UniformType.U_VEC3;
                        break block0;
                    }
                    case 4: {
                        type = UniformType.U_VEC4;
                    }
                }
            }
        }
        CCUniform uniform = CCUniform.makeUniform(name, type, count, (Shader)this);
        JsonArray jsonValues = GsonHelper.m_13933_((JsonObject)obj, (String)"values");
        if (jsonValues.size() != count && jsonValues.size() > 1) {
            throw new ChainedJsonException("Invalid amount of values specified (expected " + count + ", found " + jsonValues.size() + ")");
        }
        switch (type.getCarrier()) {
            case INT: 
            case U_INT: {
                uniform.glUniformI(CCShaderInstance.parseInts(count, jsonValues));
                break;
            }
            case FLOAT: 
            case MATRIX: {
                uniform.glUniformF(false, CCShaderInstance.parseFloats(count, jsonValues));
                break;
            }
            case DOUBLE: 
            case D_MATRIX: {
                uniform.glUniformD(false, CCShaderInstance.parseDoubles(count, jsonValues));
            }
        }
        this.f_173331_.add(uniform);
    }

    public Program compileProgram(ResourceProvider resourceProvider, Program.Type programType, ResourceLocation loc) throws IOException {
        ResourceLocation adjustedLoc = new ResourceLocation(loc.m_135827_(), "shaders/core/" + loc.m_135815_() + programType.m_85569_());
        String cacheString = "ccl__" + adjustedLoc;
        Program program = (Program)programType.m_85570_().get(cacheString);
        if (program != null) {
            return program;
        }
        GlslProcessor.ProcessedShader processedShader = new GlslProcessor(resourceProvider, adjustedLoc).process();
        int id = GL20.glCreateShader((int)programType.m_85571_());
        GL20.glShaderSource((int)id, (CharSequence)processedShader.processedSource());
        GL20.glCompileShader((int)id);
        if (GL20.glGetShaderi((int)id, (int)35713) == 0) {
            String s1 = GL20.glGetShaderInfoLog((int)id);
            throw new IOException("Couldn't compile " + programType.m_85566_() + " program (" + processedShader.sourceName() + ", " + adjustedLoc + ") : " + s1);
        }
        program = new Program(programType, id, cacheString);
        programType.m_85570_().put(cacheString, program);
        return program;
    }

    private static float[] parseFloats(int count, JsonArray jsonValues) throws ChainedJsonException {
        int i = 0;
        float[] values = new float[Math.max(count, 16)];
        for (JsonElement jsonValue : jsonValues) {
            try {
                values[i++] = GsonHelper.m_13888_((JsonElement)jsonValue, (String)"value");
            }
            catch (Exception ex) {
                ChainedJsonException chainedjsonexception = ChainedJsonException.m_135906_((Exception)ex);
                chainedjsonexception.m_135908_("values[" + i + "]");
                throw chainedjsonexception;
            }
        }
        if (count > 1 && jsonValues.size() == 1) {
            Arrays.fill(values, 1, values.length, values[0]);
        }
        return Arrays.copyOfRange(values, 0, count);
    }

    private static int[] parseInts(int count, JsonArray jsonValues) throws ChainedJsonException {
        int i = 0;
        int[] values = new int[Math.max(count, 16)];
        for (JsonElement jsonValue : jsonValues) {
            try {
                values[i++] = GsonHelper.m_13897_((JsonElement)jsonValue, (String)"value");
            }
            catch (Exception ex) {
                ChainedJsonException chainedjsonexception = ChainedJsonException.m_135906_((Exception)ex);
                chainedjsonexception.m_135908_("values[" + i + "]");
                throw chainedjsonexception;
            }
        }
        if (count > 1 && jsonValues.size() == 1) {
            Arrays.fill(values, 1, values.length, values[0]);
        }
        return Arrays.copyOfRange(values, 0, count);
    }

    private static double[] parseDoubles(int count, JsonArray jsonValues) throws ChainedJsonException {
        int i = 0;
        double[] values = new double[Math.max(count, 16)];
        for (JsonElement jsonValue : jsonValues) {
            try {
                values[i++] = GsonHelper.m_144769_((JsonElement)jsonValue, (String)"value");
            }
            catch (Exception ex) {
                ChainedJsonException chainedjsonexception = ChainedJsonException.m_135906_((Exception)ex);
                chainedjsonexception.m_135908_("values[" + i + "]");
                throw chainedjsonexception;
            }
        }
        if (count > 1 && jsonValues.size() == 1) {
            Arrays.fill(values, 1, values.length, values[0]);
        }
        return Arrays.copyOfRange(values, 0, count);
    }
}

