/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.render.entity;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import committee.nova.mods.avaritia.Static;
import committee.nova.mods.avaritia.api.client.render.CCRenderState;
import committee.nova.mods.avaritia.api.client.render.buffer.TransformingVertexConsumer;
import committee.nova.mods.avaritia.api.client.render.model.OBJParser;
import committee.nova.mods.avaritia.api.client.render.pipeline.IVertexOperation;
import committee.nova.mods.avaritia.common.entity.GapingVoidEntity;
import committee.nova.mods.avaritia.util.client.colour.Colour;
import committee.nova.mods.avaritia.util.client.colour.ColourRGBA;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class GapingVoidRender
extends EntityRenderer<GapingVoidEntity> {
    private static final ResourceLocation VOID = new ResourceLocation("avaritia", "textures/entity/void.png");

    public GapingVoidRender(EntityRendererProvider.Context context) {
        super(context);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull GapingVoidEntity p_114482_) {
        return VOID;
    }

    public void render(@NotNull GapingVoidEntity ent, float entityYaw, float ticks, @NotNull PoseStack stack, @NotNull MultiBufferSource buf, int packedLightIn) {
        double dz;
        double dy;
        float age = (float)ent.getAge() + ticks;
        Colour colour = GapingVoidRender.getColour(age, 1.0);
        double scale = GapingVoidEntity.getVoidScale(age);
        double halocoord = 0.58 * scale;
        double haloscaledist = 2.2 * scale;
        Vec3 cam = this.f_114476_.f_114358_.m_90583_();
        double dx = ent.m_20185_() - cam.m_7096_();
        double len = Math.sqrt(dx * dx + (dy = ent.m_20186_() - cam.m_7098_()) * dy + (dz = ent.m_20189_() - cam.m_7094_()) * dz);
        if (len <= haloscaledist) {
            double close = (haloscaledist - len) / haloscaledist;
            halocoord *= 1.0 + close * close * close * close * 1.5;
        }
        stack.m_85836_();
        stack.m_252781_(Axis.f_252436_.m_252977_((float)(Math.atan2(dx, dz) * 57.29577951308232)));
        stack.m_252781_(Axis.f_252529_.m_252977_((float)(Math.atan2(Math.sqrt(dx * dx + dz * dz), dy) * 57.29577951308232 + 90.0)));
        stack.m_85836_();
        stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        TransformingVertexConsumer cons = new TransformingVertexConsumer(buf.m_6299_((RenderType)RenderType.m_173209_((String)"avaritia:void_halo", (VertexFormat)DefaultVertexFormat.f_85818_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderType.f_173101_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(Static.rl("textures/entity/void_halo.png"), false, false)).m_110685_(RenderType.f_110139_).m_110687_(RenderType.f_110115_).m_110691_(false))), stack);
        cons.m_5483_(-halocoord, 0.0, -halocoord).m_6122_((int)colour.r, (int)colour.g, (int)colour.b, (int)colour.a).m_7421_(0.0f, 0.0f).m_5752_();
        cons.m_5483_(-halocoord, 0.0, halocoord).m_6122_((int)colour.r, (int)colour.g, (int)colour.b, (int)colour.a).m_7421_(0.0f, 1.0f).m_5752_();
        cons.m_5483_(halocoord, 0.0, halocoord).m_6122_((int)colour.r, (int)colour.g, (int)colour.b, (int)colour.a).m_7421_(1.0f, 1.0f).m_5752_();
        cons.m_5483_(halocoord, 0.0, -halocoord).m_6122_((int)colour.r, (int)colour.g, (int)colour.b, (int)colour.a).m_7421_(1.0f, 0.0f).m_5752_();
        stack.m_85849_();
        stack.m_85841_((float)scale, (float)scale, (float)scale);
        CCRenderState cc = CCRenderState.instance();
        cc.reset();
        cc.bind((RenderType)RenderType.m_173209_((String)"avaritia:void_hemisphere", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173071_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(VOID, false, false)).m_110661_(RenderType.f_110110_).m_110691_(false)), buf, stack);
        cc.baseColour = colour.rgba();
        new OBJParser(Static.rl("models/hemisphere.obj")).parse().get("model").render(cc, new IVertexOperation[0]);
        stack.m_85849_();
    }

    public static Colour getColour(double age, double a) {
        double l = age / 186.0;
        double f = Math.max(0.0, (l - 0.95) / 0.050000000000000044);
        f = Math.max(f, 1.0 - l * 30.0);
        return new ColourRGBA(f, f, f, a);
    }
}

