/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.screen;

import committee.nova.mods.avaritia.api.client.screen.BaseContainerScreen;
import committee.nova.mods.avaritia.common.menu.NeutronCollectorMenu;
import committee.nova.mods.avaritia.common.tile.collector.BaseNeutronCollectorTile;
import committee.nova.mods.avaritia.init.registry.ModTooltips;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class NeutronCollectorScreen
extends BaseContainerScreen<NeutronCollectorMenu> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("avaritia", "textures/gui/neutron_collector.png");
    private BaseNeutronCollectorTile tile;

    public NeutronCollectorScreen(NeutronCollectorMenu container, Inventory inventory, Component title) {
        super(container, inventory, title, BACKGROUND, 176, 166, 256, 256);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.tile = this.getTileEntity();
    }

    private BaseNeutronCollectorTile getTileEntity() {
        BlockEntity tile;
        ClientLevel level = this.getMinecraft().f_91073_;
        if (level != null && (tile = level.m_7702_(((NeutronCollectorMenu)this.m_6262_()).getBlockPos())) instanceof BaseNeutronCollectorTile) {
            BaseNeutronCollectorTile compressor = (BaseNeutronCollectorTile)tile;
            return compressor;
        }
        return null;
    }

    @Override
    public void m_88315_(@NotNull GuiGraphics stack, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(stack, mouseX, mouseY, partialTicks);
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        if (mouseX > x + 99 && mouseX < x + 104 && mouseY > y + 30 && mouseY < y + 50) {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            if (this.getProgress() > 0) {
                double i = (double)this.getProgress() / (double)this.getTimeRequired();
                MutableComponent text = ModTooltips.PROGRESS.args(NeutronCollectorScreen.fraction(i)).build();
                tooltip.add(text);
            }
            stack.m_280666_(this.f_96547_, tooltip, mouseX, mouseY);
        }
    }

    protected void m_280003_(@NotNull GuiGraphics stack, int mouseX, int mouseY) {
        String title = this.m_96636_().getString();
        stack.m_280056_(this.f_96547_, title, 88 - this.f_96547_.m_92895_(title) / 2, 6, 0x404040, false);
        stack.m_280614_(this.f_96547_, this.f_169604_, 8, 72, 0x404040, false);
    }

    protected void m_7286_(@NotNull GuiGraphics stack, float pPartialTick, int pMouseX, int pMouseY) {
        int i = this.getGuiLeft();
        int j = this.getGuiTop();
        stack.m_280163_(BACKGROUND, i, j, 0.0f, 0.0f, this.f_97726_, this.f_97727_, this.bgImgWidth, this.bgImgHeight);
        if (this.getProgress() > 0) {
            int i2 = this.getProgressBarScaled(18);
            stack.m_280218_(BACKGROUND, i + 99, j + 49 - i2, 176, 18 - i2, 4, i2);
        }
    }

    public int getProgress() {
        if (this.tile == null) {
            return 0;
        }
        return ((NeutronCollectorMenu)this.f_97732_).getProgress();
    }

    public int getTimeRequired() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getProductionTicks();
    }

    public int getProgressBarScaled(int pixels) {
        int i = Mth.m_14045_((int)this.getProgress(), (int)0, (int)this.getTimeRequired());
        int j = this.getTimeRequired();
        return (int)(j != 0 && i != 0 ? (long)i * (long)pixels / (long)j : 0L);
    }
}

