/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class InventoryUtils {
    public static ItemStack tryInsert(ItemStack itemInv, ItemStack stack) {
        AtomicReference<ItemStack> returnStack = new AtomicReference<ItemStack>(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)stack.m_41613_()));
        itemInv.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(h -> returnStack.set(ItemHandlerHelper.insertItem((IItemHandler)h, (ItemStack)stack, (boolean)false)));
        return returnStack.get();
    }

    public static ItemStack tryFilteredInsert(ItemStack itemInv, ItemStack stack) {
        if (itemInv.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent() && InventoryUtils.itemInvHasItem(itemInv, stack)) {
            return InventoryUtils.tryInsert(itemInv, stack);
        }
        return stack;
    }

    private static boolean itemInvHasItem(ItemStack itemInv, ItemStack stack) {
        AtomicBoolean hasItem = new AtomicBoolean(false);
        itemInv.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(h -> {
            for (int i = 0; i < h.getSlots(); ++i) {
                if (h.getStackInSlot(i).m_41720_() != stack.m_41720_()) continue;
                hasItem.set(true);
            }
        });
        return hasItem.get();
    }

    public static ItemStack findFirstItem(Player player, Item consumeFrom) {
        return player.m_150109_().f_35974_.stream().filter(s -> !s.m_41619_() && s.m_41720_() == consumeFrom).findFirst().orElse(ItemStack.f_41583_);
    }

    public static int getFirstSlotWithStack(ItemStack itemInv, ItemStack stack) {
        AtomicInteger slot = new AtomicInteger(-1);
        itemInv.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(h -> {
            for (int i = 0; i < h.getSlots(); ++i) {
                if (h.getStackInSlot(i).m_41720_() != stack.m_41720_()) continue;
                slot.set(i);
            }
        });
        return slot.get();
    }

    private static int getLastSlotWithStack(ItemStack itemInv, ItemStack stack) {
        AtomicInteger slot = new AtomicInteger(-1);
        itemInv.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(h -> {
            for (int i = h.getSlots() - 1; i >= 0; --i) {
                if (h.getStackInSlot(i).m_41720_() != stack.m_41720_()) continue;
                slot.set(i);
            }
        });
        return slot.get();
    }

    public static List<Integer> getAllSlotsWithStack(Player player, Predicate<ItemStack> action) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            if (!action.test(player.m_150109_().m_8020_(i))) continue;
            slots.add(i);
        }
        return slots;
    }

    public static ItemStack findInInv(Player player, Inventory playerInventory, Item item) {
        if (player.m_21205_().m_41720_() == item) {
            return player.m_21205_();
        }
        if (player.m_21206_().m_41720_() == item) {
            return player.m_21206_();
        }
        for (int x = 0; x < playerInventory.m_6643_(); ++x) {
            ItemStack stack = playerInventory.m_8020_(x);
            if (stack.m_41720_() != item) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }
}

