/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.util.client.colour;

import committee.nova.mods.avaritia.util.client.TextureUtils;
import committee.nova.mods.avaritia.util.client.colour.ColourRGBA;
import committee.nova.mods.avaritia.util.math.MathUtils;
import java.awt.image.BufferedImage;
import net.minecraft.resources.ResourceLocation;

public class CustomGradient {
    public int[] gradient;

    public CustomGradient(ResourceLocation textureFile) {
        BufferedImage img = TextureUtils.loadBufferedImage(textureFile);
        if (img == null) {
            throw new RuntimeException("File not found: " + textureFile.toString());
        }
        int[] data = new int[img.getWidth()];
        img.getRGB(0, 0, img.getWidth(), 1, data, 0, img.getWidth());
        this.gradient = new int[img.getWidth()];
        for (int i = 0; i < data.length; ++i) {
            this.gradient[i] = data[i] << 8 | data[i] >> 24 & 0xFF;
        }
    }

    public ColourRGBA getColour(double position) {
        return new ColourRGBA(this.getColourI(position));
    }

    public int getColourI(double position) {
        int off = (int)MathUtils.clip((double)this.gradient.length * position, 0.0, (double)(this.gradient.length - 1));
        return this.gradient[off];
    }
}

