/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.device;

import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.network.NetworkHooks;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.api.FluxTranslate;
import sonar.fluxnetworks.api.device.IFluxDevice;
import sonar.fluxnetworks.client.ClientCache;
import sonar.fluxnetworks.common.connection.FluxMenu;
import sonar.fluxnetworks.common.connection.FluxNetwork;
import sonar.fluxnetworks.common.connection.FluxNetworkData;
import sonar.fluxnetworks.common.connection.ServerFluxNetwork;
import sonar.fluxnetworks.common.connection.TransferHandler;
import sonar.fluxnetworks.common.util.FluxUtils;
import sonar.fluxnetworks.register.Channel;
import sonar.fluxnetworks.register.Messages;

@ParametersAreNonnullByDefault
public abstract class TileFluxDevice
extends BlockEntity
implements IFluxDevice {
    private static final BlockEntityTicker<? extends TileFluxDevice> sTickerServer = (level, pos, state, tile) -> tile.onServerTick();
    public static final int INVALID_CLIENT_COLOR = FluxUtils.getModifiedColor(0xB2B2B2, 1.1f);
    public static final int MAX_CUSTOM_NAME_LENGTH = 24;
    @Nullable
    private Player mPlayerUsing;
    @Nonnull
    private String mCustomName = "";
    @Nonnull
    private UUID mOwnerUUID = Util.f_137441_;
    private int mNetworkID = -1;
    public int mClientColor = INVALID_CLIENT_COLOR;
    protected static final int SIDES_CONNECTED_MASK = 63;
    protected static final int FLAG_FORCED_LOADING = 64;
    protected static final int FLAG_FIRST_TICKED = 128;
    protected static final int FLAG_SETTING_CHANGED = 256;
    protected static final int FLAG_ENERGY_CHANGED = 512;
    protected int mFlags;
    @Nullable
    private GlobalPos mGlobalPos;
    @Nonnull
    private FluxNetwork mNetwork = FluxNetwork.INVALID;

    protected TileFluxDevice(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Nullable
    public static <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level) {
        return level.f_46443_ ? null : sTickerServer;
    }

    public void m_7651_() {
        super.m_7651_();
        if (!this.f_58857_.f_46443_ && (this.mFlags & 0x80) != 0) {
            this.mNetwork.enqueueConnectionRemoval(this, false);
            if (this.isForcedLoading()) {
                long chunkPos = ChunkPos.m_151388_((BlockPos)this.f_58858_);
                ForgeChunkManager.forceChunk((ServerLevel)((ServerLevel)this.f_58857_), (String)"fluxnetworks", (BlockPos)this.f_58858_, (int)ChunkPos.m_45592_((long)chunkPos), (int)ChunkPos.m_45602_((long)chunkPos), (boolean)false, (boolean)true);
            }
            this.getTransferHandler().onNetworkChanged();
            this.mFlags &= 0xFFFFFF7F;
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (!this.f_58857_.f_46443_ && (this.mFlags & 0x80) != 0) {
            this.mNetwork.enqueueConnectionRemoval(this, true);
            this.getTransferHandler().onNetworkChanged();
            this.mFlags &= 0xFFFFFF7F;
        }
    }

    protected void onServerTick() {
        if ((this.mFlags & 0x80) == 0) {
            this.onFirstTick();
            this.mFlags |= 0x80;
        }
        if ((this.mFlags & 0x100) != 0) {
            this.sendBlockUpdate();
            this.mFlags &= 0xFFFFFEFF;
        } else if (this.mPlayerUsing != null) {
            Channel.get().sendToPlayer(Messages.makeDeviceBuffer(this, (byte)-1), this.mPlayerUsing);
        }
    }

    protected void onFirstTick() {
        this.connect(FluxNetworkData.getNetwork(this.mNetworkID));
    }

    public void onPlayerInteract(Player player) {
        assert (!this.f_58857_.f_46443_);
        if (this.mPlayerUsing != null) {
            player.m_5661_(FluxTranslate.ACCESS_OCCUPY, true);
        } else if (this.canPlayerAccess(player)) {
            Consumer<FriendlyByteBuf> writer = buf -> {
                buf.writeBoolean(true);
                buf.m_130064_(this.f_58858_);
                CompoundTag tag = new CompoundTag();
                this.writeCustomTag(tag, (byte)11);
                buf.m_130079_(tag);
            };
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, writer);
        } else {
            player.m_5661_(FluxTranslate.ACCESS_DENIED, true);
        }
    }

    @Nonnull
    public final FluxMenu createMenu(int containerId, Inventory inventory, Player player) {
        return new FluxMenu(containerId, inventory, this);
    }

    public boolean connect(FluxNetwork network) {
        assert (!this.f_58857_.f_46443_);
        if (this.mNetwork == network) {
            return true;
        }
        if (network.enqueueConnectionAddition(this)) {
            this.mNetwork.enqueueConnectionRemoval(this, false);
            this.mNetwork = network;
            this.mNetworkID = this.mNetwork.getNetworkID();
            this.getTransferHandler().onNetworkChanged();
            this.mFlags |= 0x100;
            this.markChunkUnsaved();
            return true;
        }
        return false;
    }

    public final void disconnect() {
        this.connect(FluxNetwork.INVALID);
    }

    @Override
    public final int getNetworkID() {
        return this.mNetworkID;
    }

    @Nonnull
    public final FluxNetwork getNetwork() {
        return this.mNetwork;
    }

    @Nonnull
    public abstract TransferHandler getTransferHandler();

    @Nonnull
    public final ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public final void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        this.readCustomTag(packet.m_131708_(), (byte)11);
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 11);
    }

    @Nonnull
    public final CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.writeCustomTag(tag, (byte)11);
        return tag;
    }

    public final void handleUpdateTag(CompoundTag tag) {
        super.m_142466_(tag);
        this.readCustomTag(tag, (byte)11);
    }

    protected final void m_183515_(@Nonnull CompoundTag tag) {
        super.m_183515_(tag);
        this.writeCustomTag(tag, (byte)1);
    }

    public final void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.readCustomTag(tag, (byte)1);
    }

    public void m_142339_(@Nonnull Level level) {
        super.m_142339_(level);
        this.mGlobalPos = GlobalPos.m_122643_((ResourceKey)level.m_46472_(), (BlockPos)this.f_58858_);
    }

    @Override
    public void writeCustomTag(@Nonnull CompoundTag tag, byte type) {
        tag.m_128405_("networkID", this.mNetworkID);
        tag.m_128359_("customName", this.mCustomName);
        this.getTransferHandler().writeCustomTag(tag, type);
        switch (type) {
            case 1: {
                tag.m_128362_("playerUUID", this.mOwnerUUID);
                break;
            }
            case 11: {
                tag.m_128362_("playerUUID", this.mOwnerUUID);
                if ((this.mFlags & 0x80) != 0) {
                    tag.m_128405_("clientColor", this.mNetwork.getNetworkColor());
                }
                tag.m_128405_("flags", this.mFlags);
                break;
            }
            case 20: {
                FluxUtils.writeGlobalPos(tag, this.getGlobalPos());
                tag.m_128344_("deviceType", this.getDeviceType().getId());
                tag.m_128362_("playerUUID", this.mOwnerUUID);
                tag.m_128379_("forcedLoading", this.isForcedLoading());
                tag.m_128379_("chunkLoaded", this.isChunkLoaded());
                this.getDisplayStack().m_41739_(tag);
            }
        }
    }

    @Override
    public void readCustomTag(@Nonnull CompoundTag tag, byte type) {
        if (type == 19) {
            boolean sort;
            String name;
            assert (!this.f_58857_.f_46443_);
            if (tag.m_128456_()) {
                return;
            }
            if (tag.m_128441_("customName") && (name = tag.m_128461_("customName")).length() <= 24) {
                this.mCustomName = name;
            }
            if ((sort = this.getTransferHandler().changeSettings(tag)) && this.mNetwork.isValid()) {
                ((ServerFluxNetwork)this.mNetwork).markSortConnections();
            }
            if (tag.m_128441_("forcedLoading")) {
                boolean load = tag.m_128471_("forcedLoading") && FluxConfig.enableChunkLoading && !this.getDeviceType().isStorage();
                long chunkPos = ChunkPos.m_151388_((BlockPos)this.f_58858_);
                ForgeChunkManager.forceChunk((ServerLevel)((ServerLevel)this.f_58857_), (String)"fluxnetworks", (BlockPos)this.f_58858_, (int)ChunkPos.m_45592_((long)chunkPos), (int)ChunkPos.m_45602_((long)chunkPos), (boolean)load, (boolean)true);
                this.setForcedLoading(load);
            }
            this.mFlags |= 0x100;
            this.markChunkUnsaved();
            return;
        }
        this.mNetworkID = tag.m_128451_("networkID");
        this.mCustomName = tag.m_128461_("customName");
        this.getTransferHandler().readCustomTag(tag, type);
        switch (type) {
            case 1: {
                this.mOwnerUUID = tag.m_128342_("playerUUID");
                break;
            }
            case 11: {
                this.mOwnerUUID = tag.m_128342_("playerUUID");
                if (tag.m_128441_("clientColor")) {
                    this.mClientColor = FluxUtils.getModifiedColor(tag.m_128451_("clientColor"), 1.1f);
                }
                this.mFlags = tag.m_128451_("flags");
                break;
            }
            case 15: {
                if (!this.f_58857_.f_46443_) break;
                this.mClientColor = FluxUtils.getModifiedColor(ClientCache.getNetwork(this.mNetworkID).getNetworkColor(), 1.1f);
            }
        }
    }

    public boolean canPlayerAccess(@Nonnull Player player) {
        assert (this.f_58857_ != null && !this.f_58857_.f_46443_);
        if (this.mNetwork.isValid()) {
            if (player.m_20148_().equals(this.mOwnerUUID)) {
                return true;
            }
            return this.mNetwork.canPlayerAccess(player);
        }
        return true;
    }

    public void sendBlockUpdate() {
        assert (this.f_58857_ != null && !this.f_58857_.f_46443_);
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 11);
    }

    public void writePacketBuffer(FriendlyByteBuf buf, byte type) {
        this.getTransferHandler().writePacketBuffer(buf, type);
    }

    public void readPacketBuffer(FriendlyByteBuf buf, byte type) {
        this.getTransferHandler().readPacketBuffer(buf, type);
    }

    public void markChunkUnsaved() {
        assert (this.f_58857_ != null);
        this.f_58857_.m_46745_(this.f_58858_).m_8092_(true);
    }

    public void markEnergyChanged() {
        this.mFlags |= 0x200;
        this.markChunkUnsaved();
    }

    @Override
    @Nonnull
    public final UUID getOwnerUUID() {
        return this.mOwnerUUID;
    }

    public final void setOwnerUUID(@Nonnull UUID uuid) {
        if (!this.mOwnerUUID.equals(uuid)) {
            this.mOwnerUUID = uuid;
            this.mFlags |= 0x100;
            this.markChunkUnsaved();
        }
    }

    @Override
    public void onPlayerOpened(Player player) {
        assert (this.mPlayerUsing == null);
        this.mPlayerUsing = player;
    }

    @Override
    public void onPlayerClosed(Player player) {
        assert (this.f_58857_.f_46443_ || this.mPlayerUsing == player);
        this.mPlayerUsing = null;
    }

    @Override
    @Nonnull
    public final String getCustomName() {
        return this.mCustomName;
    }

    @Override
    public boolean isChunkLoaded() {
        return !this.m_58901_();
    }

    @Override
    public boolean isForcedLoading() {
        return (this.mFlags & 0x40) != 0;
    }

    public void setForcedLoading(boolean forcedLoading) {
        this.mFlags = forcedLoading ? (this.mFlags |= 0x40) : (this.mFlags &= 0xFFFFFFBF);
    }

    @Override
    public final int getRawPriority() {
        return this.getTransferHandler().getRawPriority();
    }

    @Override
    public final long getRawLimit() {
        return this.getTransferHandler().getRawLimit();
    }

    @Override
    public long getMaxTransferLimit() {
        return Long.MAX_VALUE;
    }

    @Override
    public final long getTransferBuffer() {
        return this.getTransferHandler().getBuffer();
    }

    @Override
    public final long getTransferChange() {
        return this.getTransferHandler().getChange();
    }

    @Override
    @Nonnull
    public final GlobalPos getGlobalPos() {
        if (this.mGlobalPos == null) {
            this.mGlobalPos = GlobalPos.m_122643_((ResourceKey)this.f_58857_.m_46472_(), (BlockPos)this.f_58858_);
        }
        return this.mGlobalPos;
    }

    @Override
    public final boolean getDisableLimit() {
        return this.getTransferHandler().getDisableLimit();
    }

    @Override
    public final boolean getSurgeMode() {
        return this.getTransferHandler().getSurgeMode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{mNetworkID=" + this.mNetworkID + ", mGlobalPos=" + this.mGlobalPos + "}";
    }
}

