/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.raytracer;

import codechicken.lib.vec.Vector3;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;

public class RayTracer {
    public static BlockHitResult retraceBlock(BlockGetter level, Player player, BlockPos pos) {
        BlockHitResult raytraceTraceShape;
        Vec3 startVec = RayTracer.getStartVec(player);
        Vec3 endVec = RayTracer.getEndVec(player);
        BlockState state = level.m_8055_(pos);
        VoxelShape baseShape = state.m_60808_(level, pos);
        BlockHitResult baseTraceResult = baseShape.m_83220_(startVec, endVec, pos);
        if (baseTraceResult != null && (raytraceTraceShape = state.m_60771_(level, pos, CollisionContext.m_82750_((Entity)player)).m_83220_(startVec, endVec, pos)) != null) {
            return raytraceTraceShape;
        }
        return baseTraceResult;
    }

    private static double getBlockReachDistance_server(ServerPlayer player) {
        return player.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get()).m_22135_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static double getBlockReachDistance_client() {
        return Minecraft.m_91087_().f_91072_.m_105286_();
    }

    public static BlockHitResult retrace(Player player) {
        return RayTracer.retrace(player, ClipContext.Block.OUTLINE);
    }

    public static BlockHitResult retrace(Player player, ClipContext.Block blockMode) {
        return RayTracer.retrace(player, RayTracer.getBlockReachDistance(player), blockMode, ClipContext.Fluid.NONE);
    }

    public static BlockHitResult retrace(Player player, ClipContext.Block blockMode, ClipContext.Fluid fluidMode) {
        return RayTracer.retrace(player, RayTracer.getBlockReachDistance(player), blockMode, fluidMode);
    }

    public static BlockHitResult retrace(Player player, double reach, ClipContext.Block blockMode) {
        return RayTracer.retrace(player, reach, blockMode, ClipContext.Fluid.NONE);
    }

    public static BlockHitResult retrace(Player player, double reach, ClipContext.Block blockMode, ClipContext.Fluid fluidMode) {
        Vec3 startVec = RayTracer.getStartVec(player);
        Vec3 endVec = RayTracer.getEndVec(player, reach);
        return player.m_9236_().m_45547_(new ClipContext(startVec, endVec, blockMode, fluidMode, (Entity)player));
    }

    public static Vec3 getCorrectedHeadVec(Player player) {
        Vector3 v = Vector3.fromEntity((Entity)player).add(0.0, player.m_20192_(), 0.0);
        return v.vec3();
    }

    public static Vec3 getStartVec(Player player) {
        return RayTracer.getCorrectedHeadVec(player);
    }

    @Deprecated
    public static double getBlockReachDistance(Player player) {
        return player.m_9236_().f_46443_ ? RayTracer.getBlockReachDistance_client() : (player instanceof ServerPlayer ? RayTracer.getBlockReachDistance_server((ServerPlayer)player) : 5.0);
    }

    public static Vec3 getEndVec(Player player) {
        Vec3 headVec = RayTracer.getCorrectedHeadVec(player);
        Vec3 lookVec = player.m_20252_(1.0f);
        double reach = RayTracer.getBlockReachDistance(player);
        return headVec.m_82520_(lookVec.f_82479_ * reach, lookVec.f_82480_ * reach, lookVec.f_82481_ * reach);
    }

    public static Vec3 getEndVec(Player player, double reach) {
        Vec3 headVec = RayTracer.getCorrectedHeadVec(player);
        Vec3 lookVec = player.m_20252_(1.0f);
        return headVec.m_82520_(lookVec.f_82479_ * reach, lookVec.f_82480_ * reach, lookVec.f_82481_ * reach);
    }
}

