/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.compiler.tree;

import icyllis.arc3d.compiler.tree.Expression;
import icyllis.arc3d.compiler.tree.Node;
import icyllis.arc3d.compiler.tree.Statement;
import icyllis.arc3d.compiler.tree.TreeVisitor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ReturnStatement
extends Statement {
    @Nullable
    private Expression mExpression;

    private ReturnStatement(int position, @Nullable Expression expression) {
        super(position);
        this.mExpression = expression;
    }

    public static Statement make(int pos, @Nullable Expression expression) {
        return new ReturnStatement(pos, expression);
    }

    @Nullable
    public Expression getExpression() {
        return this.mExpression;
    }

    public void setExpression(@Nullable Expression expression) {
        this.mExpression = expression;
    }

    @Override
    public Node.StatementKind getKind() {
        return Node.StatementKind.RETURN;
    }

    @Override
    public boolean accept(@Nonnull TreeVisitor visitor) {
        if (visitor.visitReturn(this)) {
            return true;
        }
        return this.mExpression != null && this.mExpression.accept(visitor);
    }

    @Override
    @Nonnull
    public String toString() {
        if (this.mExpression != null) {
            return "return " + this.mExpression + ";";
        }
        return "return;";
    }
}

