/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.granite;

import icyllis.arc3d.core.RefCnt;
import icyllis.arc3d.core.SharedPtr;
import icyllis.arc3d.engine.CommandBuffer;
import icyllis.arc3d.engine.ImmediateContext;
import icyllis.arc3d.engine.RecordingContext;
import icyllis.arc3d.engine.Resource;
import icyllis.arc3d.engine.task.Task;
import icyllis.arc3d.engine.task.TaskList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;

public class RootTask
extends Task {
    private final TaskList mRootTaskList;
    private final ObjectArrayList<@SharedPtr Resource> mExtraResourceRefs;

    public RootTask(TaskList rootTaskList, ObjectArrayList<@SharedPtr Resource> extraResourceRefs) {
        this.mRootTaskList = rootTaskList;
        this.mExtraResourceRefs = extraResourceRefs;
    }

    @Override
    public int prepare(RecordingContext context) {
        return 0;
    }

    @Override
    public int execute(ImmediateContext context, CommandBuffer commandBuffer) {
        for (Resource resource : this.mExtraResourceRefs) {
            commandBuffer.trackResource(RefCnt.create(resource));
        }
        return this.mRootTaskList.execute(context, commandBuffer);
    }

    @Override
    protected void deallocate() {
        this.mRootTaskList.close();
        this.mExtraResourceRefs.forEach(Resource::unref);
        this.mExtraResourceRefs.clear();
    }

    public String toString() {
        return "RootTask{mRootTaskList=" + this.mRootTaskList + ", mExtraResourceRefs=" + this.mExtraResourceRefs + "}";
    }
}

