/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.granite.shading;

import icyllis.arc3d.engine.Caps;
import icyllis.arc3d.engine.ShaderCaps;
import icyllis.arc3d.engine.ShaderVar;
import icyllis.arc3d.engine.trash.GraphicsPipelineDesc_Old;
import icyllis.arc3d.engine.trash.PipelineKey_old;
import icyllis.arc3d.granite.GeometryStep;
import icyllis.arc3d.granite.shading.FragmentShaderBuilder;
import icyllis.arc3d.granite.shading.UniformHandler;
import icyllis.arc3d.granite.shading.VaryingHandler;
import icyllis.arc3d.granite.shading.VertexShaderBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class GraphicsPipelineBuilder {
    private int mStageIndex = -1;
    private final IntArrayList mSubstageIndices = new IntArrayList();
    public VertexShaderBuilder mVS;
    public FragmentShaderBuilder mFS;
    public final PipelineKey_old mDesc;
    public final GraphicsPipelineDesc_Old mGraphicsPipelineDesc;
    private final Caps mCaps;
    public int mProjectionUniform = -1;
    public GeometryStep.ProgramImpl mGPImpl;
    private int mNumFragmentSamplers;

    public GraphicsPipelineBuilder(PipelineKey_old desc, GraphicsPipelineDesc_Old graphicsPipelineDesc, Caps caps) {
        this.mDesc = desc;
        this.mGraphicsPipelineDesc = graphicsPipelineDesc;
        this.mCaps = caps;
        this.mVS = new VertexShaderBuilder(this);
        this.mFS = new FragmentShaderBuilder(this);
    }

    public final Caps getCaps() {
        return this.mCaps;
    }

    public final ShaderCaps shaderCaps() {
        return this.getCaps().shaderCaps();
    }

    public final String nameVariable(char prefix, String name) {
        return this.nameVariable(prefix, name, true);
    }

    public final String nameVariable(char prefix, String name, boolean mangle) {
        Object out = prefix == '\u0000' ? name : (name.startsWith("_") ? prefix + "_x" + name : prefix + "_" + name);
        if (mangle) {
            String suffix = this.getMangleSuffix();
            out = ((String)out).endsWith("_") ? (String)out + "x" + suffix : (String)out + suffix;
        }
        assert (!((String)out).contains("__"));
        return out;
    }

    public abstract UniformHandler uniformHandler();

    public abstract VaryingHandler varyingHandler();

    public final void addExtension(int shaderFlags, @Nullable String extensionName) {
        if (extensionName == null) {
            return;
        }
        if ((shaderFlags & 1) != 0) {
            this.mVS.addExtension(extensionName);
        }
        if ((shaderFlags & 4) != 0) {
            this.mFS.addExtension(extensionName);
        }
    }

    protected final boolean emitAndInstallProcs() {
        String[] input = new String[2];
        if (!this.emitAndInstallGeomProc(input)) {
            return false;
        }
        if (!this.emitAndInstallFragProcs(input)) {
            return false;
        }
        this.mFS.codeAppendf("%s = %s * %s;\n", "FragColor0", input[0], input[1]);
        return true;
    }

    private void advanceStage() {
        ++this.mStageIndex;
        this.mFS.nextStage();
    }

    @Nonnull
    private String getMangleSuffix() {
        assert (this.mStageIndex >= 0);
        StringBuilder suffix = new StringBuilder("_S").append(this.mStageIndex);
        IntListIterator intListIterator = this.mSubstageIndices.iterator();
        while (intListIterator.hasNext()) {
            int c = (Integer)intListIterator.next();
            suffix.append("_c").append(c);
        }
        return suffix.toString();
    }

    private boolean emitAndInstallGeomProc(String[] output) {
        GeometryStep geomProc = this.mGraphicsPipelineDesc.geomProc();
        this.advanceStage();
        if (output[0] == null) {
            output[0] = this.nameVariable('\u0000', "outputColor");
        }
        if (output[1] == null) {
            output[1] = this.nameVariable('\u0000', "outputCoverage");
        }
        assert (this.mProjectionUniform == -1);
        this.mProjectionUniform = this.uniformHandler().addUniform(1, (byte)16, "SV_Projection", -1);
        this.mFS.codeAppendf("// Stage %d, %s\n", this.mStageIndex, geomProc.name());
        this.mVS.codeAppendf("// Geometry Processor %s\n", geomProc.name());
        assert (this.mGPImpl == null);
        this.mGPImpl = geomProc.makeProgramImpl(this.shaderCaps());
        int[] texSamplers = new int[geomProc.numTextureSamplers()];
        for (int i = 0; i < texSamplers.length; ++i) {
            String name = "TextureSampler" + i;
            texSamplers[i] = this.emitSampler(geomProc.textureSamplerState(i), geomProc.textureSamplerSwizzle(i), name);
            if (texSamplers[i] != -1) continue;
            return false;
        }
        this.mGPImpl.emitCode(this.mVS, this.mFS, this.varyingHandler(), this.uniformHandler(), this.shaderCaps(), geomProc, output[0], output[1], texSamplers);
        return true;
    }

    private boolean emitAndInstallFragProcs(String[] input) {
        return true;
    }

    private int emitSampler(int samplerState, short swizzle, String name) {
        ++this.mNumFragmentSamplers;
        return -1;
    }

    void appendDecls(ArrayList<ShaderVar> vars, StringBuilder out) {
        for (ShaderVar var : vars) {
            var.appendDecl(out);
            out.append(";\n");
        }
    }
}

