/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.graphics;

import icyllis.arc3d.core.Matrix4;
import icyllis.arc3d.core.RawPtr;
import icyllis.arc3d.core.Rect2f;
import icyllis.arc3d.core.Rect2i;
import icyllis.arc3d.core.SamplingOptions;
import icyllis.arc3d.core.TextBlob;
import icyllis.arc3d.core.Vertices;
import icyllis.modernui.annotation.NonNull;
import icyllis.modernui.annotation.Nullable;
import icyllis.modernui.graphics.BlendMode;
import icyllis.modernui.graphics.Canvas;
import icyllis.modernui.graphics.Image;
import icyllis.modernui.graphics.Matrix;
import icyllis.modernui.graphics.Paint;
import icyllis.modernui.graphics.RectF;
import icyllis.modernui.graphics.text.Font;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ArcCanvas
extends Canvas {
    @RawPtr
    private icyllis.arc3d.core.Canvas mCanvas;

    public ArcCanvas(@RawPtr icyllis.arc3d.core.Canvas canvas) {
        this.mCanvas = canvas;
    }

    @RawPtr
    public icyllis.arc3d.core.Canvas getCanvas() {
        return this.mCanvas;
    }

    @Override
    public int save() {
        return this.mCanvas.save();
    }

    @Override
    public int saveLayer(float left, float top, float right, float bottom, int alpha) {
        return this.save();
    }

    @Override
    public void restore() {
        this.mCanvas.restore();
    }

    @Override
    public int getSaveCount() {
        return this.mCanvas.getSaveCount();
    }

    @Override
    public void restoreToCount(int saveCount) {
        this.mCanvas.restoreToCount(saveCount);
    }

    @Override
    public void translate(float dx, float dy) {
        this.mCanvas.translate(dx, dy);
    }

    @Override
    public void translate(float dx, float dy, float dz) {
        this.mCanvas.translate(dx, dy, dz);
    }

    @Override
    public void scale(float sx, float sy) {
        this.mCanvas.scale(sx, sy);
    }

    @Override
    public void scale(float sx, float sy, float sz) {
        this.mCanvas.scale(sx, sy, sz);
    }

    @Override
    public void scale(float sx, float sy, float px, float py) {
        this.mCanvas.scale(sx, sy, px, py);
    }

    @Override
    public void rotate(float degrees) {
        this.mCanvas.rotate(degrees);
    }

    @Override
    public void rotate(float degrees, float px, float py) {
        this.mCanvas.rotate(degrees, px, py);
    }

    @Override
    public void shear(float sx, float sy) {
        this.mCanvas.shear(sx, sy);
    }

    @Override
    public void shear(float sx, float sy, float px, float py) {
        this.mCanvas.shear(sx, sy, px, py);
    }

    @Override
    public void concat(@NonNull Matrix matrix) {
        this.mCanvas.concat(matrix);
    }

    @Override
    public void concat(@NonNull Matrix4 matrix) {
        this.mCanvas.concat(matrix);
    }

    @Override
    @NonNull
    public Matrix4 getMatrix() {
        Matrix4 mat = new Matrix4();
        this.mCanvas.getLocalToDevice(mat);
        return mat;
    }

    @Override
    public boolean clipRect(float left, float top, float right, float bottom) {
        this.mCanvas.clipRect(left, top, right, bottom, 1);
        return !this.mCanvas.isClipEmpty();
    }

    @Override
    public boolean clipOutRect(float left, float top, float right, float bottom) {
        this.mCanvas.clipRect(left, top, right, bottom, 0);
        return !this.mCanvas.isClipEmpty();
    }

    @Override
    public boolean quickReject(float left, float top, float right, float bottom) {
        return this.mCanvas.quickReject(left, top, right, bottom);
    }

    @Override
    public boolean getLocalClipBounds(@NonNull RectF bounds) {
        Rect2i devClipBounds = new Rect2i();
        if (!this.mCanvas.getDeviceClipBounds(devClipBounds)) {
            bounds.setEmpty();
            return false;
        }
        Matrix inverse = new Matrix();
        this.mCanvas.getLocalToDevice(inverse);
        if (!inverse.invert()) {
            bounds.setEmpty();
            return false;
        }
        bounds.set(devClipBounds.left(), devClipBounds.top(), devClipBounds.right(), devClipBounds.bottom());
        inverse.mapRect(bounds);
        return !bounds.isEmpty();
    }

    @Override
    public void drawColor(int color, @NonNull BlendMode mode) {
        this.mCanvas.drawColor(color, mode.getNativeBlendMode());
    }

    @Override
    public void drawColor(float r, float g, float b, float a, @NonNull BlendMode mode) {
        this.mCanvas.drawColor(r, g, b, a, mode.getNativeBlendMode());
    }

    @Override
    public void drawPaint(@NonNull Paint paint) {
        this.mCanvas.drawPaint(paint.getNativePaint());
    }

    @Override
    public void drawPoint(float x, float y, @NonNull Paint paint) {
        this.mCanvas.drawPoint(x, y, paint.getNativePaint());
    }

    @Override
    public void drawPoints(@NonNull float[] pts, int offset, int count, @NonNull Paint paint) {
        Objects.checkFromIndexSize(offset, count, pts.length);
        this.mCanvas.drawPoints(0, pts, offset, count >> 1, paint.getNativePaint());
    }

    @Override
    public void drawLine(float x0, float y0, float x1, float y1, @NonNull Paint paint) {
        this.mCanvas.drawLine(x0, y0, x1, y1, paint.getNativePaint());
    }

    @Override
    public void drawLine(float x0, float y0, float x1, float y1, @NonNull Paint.Cap cap, float thickness, @NonNull Paint paint) {
        this.mCanvas.drawLine(x0, y0, x1, y1, cap.nativeInt, thickness, paint.getNativePaint());
    }

    @Override
    public void drawLines(@NonNull float[] pts, int offset, int count, boolean connected, @NonNull Paint paint) {
        Objects.checkFromIndexSize(offset, count, pts.length);
        this.mCanvas.drawPoints(connected ? 2 : 1, pts, offset, count >> 1, paint.getNativePaint());
    }

    @Override
    public void drawRect(float left, float top, float right, float bottom, @NonNull Paint paint) {
        this.mCanvas.drawRect(left, top, right, bottom, paint.getNativePaint());
    }

    @Override
    public void drawRectGradient(float left, float top, float right, float bottom, int colorUL, int colorUR, int colorLR, int colorLL, Paint paint) {
        this.mCanvas.drawRect(left, top, right, bottom, paint.getNativePaint());
    }

    @Override
    public void drawRoundRect(float left, float top, float right, float bottom, float radius, @NonNull Paint paint) {
        this.mCanvas.drawRoundRect(left, top, right, bottom, radius, paint.getNativePaint());
    }

    @Override
    public void drawRoundRect(float left, float top, float right, float bottom, float radius, int sides, @NonNull Paint paint) {
        this.mCanvas.drawRoundRect(left, top, right, bottom, radius, paint.getNativePaint());
    }

    @Override
    public void drawRoundRectGradient(float left, float top, float right, float bottom, int colorUL, int colorUR, int colorLR, int colorLL, float radius, Paint paint) {
        this.mCanvas.drawRoundRect(left, top, right, bottom, radius, paint.getNativePaint());
    }

    @Override
    public void drawCircle(float cx, float cy, float radius, @NonNull Paint paint) {
        this.mCanvas.drawCircle(cx, cy, radius, paint.getNativePaint());
    }

    @Override
    public void drawArc(float cx, float cy, float radius, float startAngle, float sweepAngle, @NonNull Paint paint) {
        this.mCanvas.drawArc(cx, cy, radius, startAngle, sweepAngle, paint.getNativePaint());
    }

    @Override
    public void drawArc(float cx, float cy, float radius, float startAngle, float sweepAngle, @NonNull Paint.Cap cap, float thickness, @NonNull Paint paint) {
        this.mCanvas.drawArc(cx, cy, radius, startAngle, sweepAngle, cap.nativeInt, thickness, paint.getNativePaint());
    }

    @Override
    public void drawPie(float cx, float cy, float radius, float startAngle, float sweepAngle, @NonNull Paint paint) {
        this.mCanvas.drawPie(cx, cy, radius, startAngle, sweepAngle, paint.getNativePaint());
    }

    @Override
    public void drawChord(float cx, float cy, float radius, float startAngle, float sweepAngle, @NonNull Paint paint) {
        this.mCanvas.drawChord(cx, cy, radius, startAngle, sweepAngle, paint.getNativePaint());
    }

    @Override
    public void drawBezier(float x0, float y0, float x1, float y1, float x2, float y2, Paint paint) {
    }

    @Override
    public void drawImage(Image image, float left, float top, @Nullable Paint paint) {
        if (image == null) {
            return;
        }
        this.mCanvas.drawImage(image.getNativeImage(), left, top, paint != null && paint.getFilterMode() == 0 ? SamplingOptions.POINT : SamplingOptions.LINEAR, paint != null ? paint.getNativePaint() : null);
    }

    @Override
    public void drawImage(Image image, float srcLeft, float srcTop, float srcRight, float srcBottom, float dstLeft, float dstTop, float dstRight, float dstBottom, @Nullable Paint paint) {
        if (image == null) {
            return;
        }
        this.mCanvas.drawImageRect(image.getNativeImage(), new Rect2f(srcLeft, srcTop, srcRight, srcBottom), new Rect2f(dstLeft, dstTop, dstRight, dstBottom), paint != null && paint.getFilterMode() == 0 ? SamplingOptions.POINT : SamplingOptions.LINEAR, paint != null ? paint.getNativePaint() : null, 0);
    }

    @Override
    public void drawRoundImage(Image image, float left, float top, float radius, @Nullable Paint paint) {
        this.drawImage(image, left, top, paint);
    }

    @Override
    public void drawGlyphs(@NonNull int[] glyphs, int glyphOffset, @NonNull float[] positions, int positionOffset, int glyphCount, @NonNull Font font, float x, float y, @NonNull Paint paint) {
        icyllis.arc3d.core.Font nativeFont = new icyllis.arc3d.core.Font();
        nativeFont.setTypeface(font.getNativeTypeface());
        if (nativeFont.getTypeface() == null) {
            return;
        }
        paint.getNativeFont(nativeFont);
        this.mCanvas.drawGlyphs(glyphs, glyphOffset, positions, positionOffset, glyphCount, x, y, nativeFont, paint.getNativePaint());
    }

    @Override
    public void drawTextBlob(TextBlob blob, float x, float y, @NonNull Paint paint) {
        this.mCanvas.drawTextBlob(blob, x, y, paint.getNativePaint());
    }

    @Override
    public void drawVertices(@NonNull Canvas.VertexMode mode, int vertexCount, @NonNull float[] positions, int positionOffset, @Nullable float[] texCoords, int texCoordOffset, @Nullable int[] colors, int colorOffset, @Nullable short[] indices, int indexOffset, int indexCount, @Nullable BlendMode blendMode, @NonNull Paint paint) {
        Objects.checkFromIndexSize(positionOffset, vertexCount, positions.length);
        if (texCoords != null) {
            Objects.checkFromIndexSize(texCoordOffset, vertexCount, texCoords.length);
        }
        if (colors != null) {
            Objects.checkFromIndexSize(colorOffset, vertexCount >> 1, colors.length);
        }
        if (indices != null) {
            Objects.checkFromIndexSize(indexOffset, indexCount, indices.length);
        }
        if (vertexCount < 2) {
            return;
        }
        Vertices vertices = Vertices.makeCopy(mode.nativeInt, vertexCount >> 1, positions, positionOffset, texCoords, texCoordOffset, colors, colorOffset, indices, indexOffset, indexCount);
        icyllis.arc3d.core.Paint nativePaint = paint.getNativePaint();
        if (blendMode == null) {
            blendMode = nativePaint.getShader() != null ? BlendMode.MODULATE : BlendMode.DST;
        }
        this.mCanvas.drawVertices(vertices, blendMode.getNativeBlendMode(), nativePaint);
    }

    @Override
    public void drawMesh(@NonNull Canvas.VertexMode mode, @NonNull FloatBuffer positions, @Nullable FloatBuffer texCoords, @Nullable IntBuffer colors, @Nullable ShortBuffer indices, @Nullable BlendMode blendMode, @NonNull Paint paint) {
        if (positions.remaining() < 2) {
            return;
        }
        Vertices vertices = Vertices.makeCopy(mode.nativeInt, positions, texCoords, colors, indices);
        icyllis.arc3d.core.Paint nativePaint = paint.getNativePaint();
        if (blendMode == null) {
            blendMode = nativePaint.getShader() != null ? BlendMode.MODULATE : BlendMode.DST;
        }
        this.mCanvas.drawVertices(vertices, blendMode.getNativeBlendMode(), nativePaint);
    }

    @Override
    public boolean isClipEmpty() {
        return this.mCanvas.isClipEmpty();
    }

    @Override
    public boolean isClipRect() {
        return this.mCanvas.isClipRect();
    }
}

