/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.graphics.text;

import java.text.CharacterIterator;
import java.util.Objects;
import javax.annotation.Nonnull;

public class CharArrayIterator
implements CharacterIterator {
    private final char[] text;
    private final int start;
    private final int end;
    private int pos;

    public CharArrayIterator(char[] text) {
        this(text, 0, text.length);
    }

    public CharArrayIterator(char[] text, int start) {
        this(text, start, text.length);
    }

    public CharArrayIterator(@Nonnull char[] text, int start, int end) {
        this.pos = Objects.checkFromToIndex(start, end, text.length);
        this.text = text;
        this.start = start;
        this.end = end;
    }

    @Override
    public char first() {
        this.pos = this.start;
        return this.current();
    }

    @Override
    public char last() {
        this.pos = this.end != this.start ? this.end - 1 : this.end;
        return this.current();
    }

    @Override
    public char current() {
        return this.pos >= this.start && this.pos < this.end ? this.text[this.pos] : (char)'\uffff';
    }

    @Override
    public char next() {
        ++this.pos;
        if (this.pos >= this.end) {
            this.pos = this.end;
            return '\uffff';
        }
        return this.current();
    }

    @Override
    public char previous() {
        if (this.pos == this.start) {
            return '\uffff';
        }
        --this.pos;
        return this.current();
    }

    @Override
    public char setIndex(int position) {
        if (position < this.start || position > this.end) {
            throw new IllegalArgumentException();
        }
        this.pos = position;
        return this.current();
    }

    @Override
    public int getBeginIndex() {
        return this.start;
    }

    @Override
    public int getEndIndex() {
        return this.end;
    }

    @Override
    public int getIndex() {
        return this.pos;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

